/****************************************************************************
 *
 *      $Id: str_fmt.c,v 1.2 2002/05/31 06:14:11 danielp Exp $
 *      Copyright (C) 2002 Operating Systems Research Group, UNSW, Australia.
 *
 *      This file is part of the Mungi operating system distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *	version 2 as published by the Free Software Foundation.
 *	A copy of this license is included in the top level directory of 
 *	the Mungi distribution.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 ****************************************************************************/

#include <mungi/klibc.h>

/** str_fmt(p,size,fmt) format p in a field size in width using fmt */
void str_fmt (char *p, int size, int fmt)
{
    int             n, m, len;

    len = strlen (p);
    switch (fmt) {
    case FMT_RJUST:
	for (n = size - len; n > 0; n--)
	    strichr (p, ' ');
	break;
    case FMT_LJUST:
	for (m = size - len; m > 0; m--)
	    strcat (p, " ");
	break;
    case FMT_RJUST0:
	for (n = size - len; n > 0; n--)
	    strichr (p, '0');
	break;
    case FMT_CENTER:
	m = (size - len) / 2;
	n = size - (len + m);
	for (; m > 0; m--)
	    strcat (p, " ");
	for (; n > 0; n--)
	    strichr (p, ' ');
	break;
    }
}
