/****************************************************************************
 *
 *      $Id: CNameTree_cci.c,v 1.5 2002/07/31 07:04:43 cgray Exp $
 *      Copyright (C) 2002 Operating Systems Research Group, UNSW, Australia.
 *
 *      This file is part of the Mungi operating system distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *	version 2 as published by the Free Software Foundation.
 *	A copy of this license is included in the top level directory of 
 *	the Mungi distribution.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 ****************************************************************************/

/***************************************************************************************************
 *
 * CNameTree_cci.c
 *
 * Implementation of the CNameTree component-class.
 * Autogenerated by PaxGen-0.1 on Tue Oct 23 11:42:46 2001
 *
 **************************************************************************************************/

/* Includes */
#include <assert.h>
#include "tree.h"
#include "CNameTree_cc.h"

#include "../nstree.h"
#include "../abort_test.h"

/* component functions */
void UserPrint( char*, ... );

/* bottom 3 bits! */
#define LONG_ALIGN_BITS 7L

/* default lookup values for the root */
/* FIXME: flags should have dir bit set */
#define ROOT_VALUE 0
#define ROOT_FLAGS (nsentflag_t){{0}}


extern void *hmalloc_access(void *vdat);

/* check we have all the caps we need in our APD */
/* FIXME: this should do better with multiple clients
 * and could also handle with pagefaults
 */
static void check_apd( cnt_t *cthis, cap_t obj )
{
	apddesc_t myapd;
	clist_t *clist = NULL;
	cap_t *cap;

	/* validate access to something */
	cap = ApdLookup( cthis->malloc_cap.address, M_READ );
	
	/* put some stuff into our APD? */
	if( cap == NULL )
	{
		ApdGet( &myapd );
		clist = myapd.clist[0].address;
		clist->caps[clist->n_caps++] = obj; /* user's data */
		clist->caps[clist->n_caps++] = cthis->malloc_cap; /* tree */

		hmalloc_access( cthis->malloc_cap.address );
	}

}


/* INameTree interface */
btcerror_t cnt_int_create( cnt_t *cthis, cap_t obj, long name_offset, 
			   long flags, long value )
{
	int r;

	if( cthis->btree == NULL )
	{
		UserPrint( "BTree is null... creating\n" );
		r = ns_create( &cthis->btree, &cthis->malloc_cap );
		UserPrint( "done\n" );

		/* couldn't create BTree */
		if( r != 0 )
			return BTC_ERROR;
	}

	/* put some stuff into our APD? */
	check_apd(cthis, obj);

	/* now do the actual insert */
	r = ns_add( cthis->btree, obj.address + name_offset, 
		    (nsentflag_t) {{flags}}, (void*) value );

	if( r != NST_OK )
	{
		UserPrint( "tree: Create Returning Error!\n" );
		return BTC_ERROR;
	}
	
	return BTC_OK;
}

btcerror_t cnt_int_delete( cnt_t *cthis, cap_t obj, long name_offset )
{
	int r;

	if( cthis->btree == NULL )
		return BTC_ERROR;

	/* put some stuff into our APD? */
	check_apd(cthis, obj);

	/* now do the actual lookup */
	r = ns_del( cthis->btree, obj.address + name_offset );

	if( r != NST_OK )
		return BTC_ERROR;

	return BTC_OK;
}

btcerror_t cnt_int_lookup( cnt_t *cthis, cap_t obj, long name_offset, 
			   int ret_flags, int ret_offset )
{
	int r;
	nsent_t *dat, *ent;

	if( cthis->btree == NULL )
		return BTC_ERROR;

	/* put some stuff into our APD? */
	check_apd(cthis, obj);

	/* now do the actual lookup */
	r = ns_lookup( cthis->btree, obj.address + name_offset, &dat );

	if( r != NST_OK )
		return BTC_ERROR;

	/* where we are returning data into */
	ent = (nsent_t*) (((long)obj.address) + ret_offset);

	/* we don't actually store flags or value for the root, so we
	   define it */
	if( dat != NULL )
	{
		ent->value = dat->value;
		ent->flags = dat->flags;
	}
	else
	{
		ent->value = ROOT_VALUE;
		ent->flags = ROOT_FLAGS;
	}

	return BTC_OK;
}

btcerror_t cnt_int_modify( cnt_t *cthis, cap_t obj, long name_offset, 
			   long new_name_offset, long flags, long value )
{
	int r;
	nsent_t newdat;
	char *rename = NULL;

	assert( obj.address );

	if( cthis->btree == NULL )
		return BTC_ERROR;

	/* put some stuff into our APD? */
	check_apd(cthis, obj);
	
	newdat.flags.flags.all = flags;
	newdat.value = (void *)value;

	if( new_name_offset != -1 )
		rename = obj.address + new_name_offset;

	r = ns_modify( cthis->btree, (char*)(obj.address + name_offset), 
		       &newdat, rename );

	if( r != NST_OK )
		return BTC_ERROR;

	return BTC_OK;
}

btcerror_t cnt_int_rlookup( cnt_t *cthis, cap_t obj, long name_offset, long start, long overflow, long recv_off, long recv_len, long num, long value )
{
	int r;
	char *dir;
	unsigned char *recv_buf;

	assert( obj.address != NULL );

	if( cthis->btree == NULL )
		return BTC_ERROR;

	/* put some stuff into our APD? */
	check_apd(cthis, obj);

	dir = obj.address + name_offset;

	/* check alignment of the recv buffer */
	recv_buf = obj.address + recv_off;

	if( (((long)recv_buf) & LONG_ALIGN_BITS) != 0 )
		return BTC_ERROR;

	r = ns_rlookup( cthis->btree, dir, start, 
			overflow, recv_buf, recv_len, num, (void *)value );

	/* FIXME: mem fail? */
	if( r == NST_FAIL )
		return BTC_ERROR;

	return BTC_OK;
}

btcerror_t cnt_int_fenum( cnt_t *cthis, cap_t obj, long name_offset, 
			  long start, long overflow, long recv_off, 
			  long recv_len, long num, long value )
{
	int r;
	char *dir;
	unsigned char *recv_buf;

	assert( obj.address != NULL );

	if( cthis->btree == NULL )
		return BTC_ERROR;

	/* put some stuff into our APD? */
	check_apd(cthis, obj);

	dir = obj.address + name_offset;

	/* ABORT?? */
#if ABORT_LEVEL == ABORT_MCS
	{
		nsenum_t *dat;

		dat = (nsenum_t*) ( obj.address + recv_off);
	        dat[0].first.num = 1;
	        dat[0].first.next_start = start + 1;
	        dat[0].first.next_overflow = 0;

		if( start >= ABORT_MAX_COUNT )
			dat[0].first.num = 0;  /* end */

		dat[1].other.value = 0;
		dat[1].other.flags.flags.all = 0;
		dat[1].other.arrnext = 3;
		strcpy( (char*) &(dat[2]), "a" ); /* boring name */

		return BTC_OK;
	}
#endif		

	/* check alignment of the recv buffer */
	recv_buf = obj.address + recv_off;

	if( (((long)recv_buf) & LONG_ALIGN_BITS) != 0 )
		return BTC_ERROR;

	r = ns_enum( cthis->btree, dir, start, 
		     overflow, recv_buf, recv_len, num );

	/* FIXME: mem fail? */
	if( r == NST_FAIL )
		return BTC_ERROR;

	return BTC_OK;
}


