/****************************************************************************
 *
 *      $Id: INameTree_io.c,v 1.5 2002/08/21 06:10:58 luked Exp $
 *      Copyright (C) 2002 Operating Systems Research Group, UNSW, Australia.
 *
 *      This file is part of the Mungi operating system distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *	version 2 as published by the Free Software Foundation.
 *	A copy of this license is included in the top level directory of 
 *	the Mungi distribution.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 ****************************************************************************/

/***************************************************************************************************
 *
 * INameTree_io.c
 *
 * Interface object proxy implementations for INameTree.
 * Autogenerated by PaxGen-0.1 on Tue Oct 23 11:42:46 2001
 *
 **************************************************************************************************/

/* includes */
#include <assert.h>
#include "tree.h"
#include "INameTree_io.h"
#include <stdlib.h>
#include <string.h>

INameTree_t *int_get_typeinfo( INameTree_t *cthis, environment_t *ev );

/* Implementation of proxies for IDL defined methods */
btcerror_t int_create( INameTree_t *cthis, cap_t obj, long name_offset, long flags, long value, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = flags;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = value;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);

	/* get the entry point */
	_ept = cthis->epts[MID_INT_CREATE - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, MID_INT_CREATE, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_CREATE - MID_INT_START] = _ept;
	}

	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

btcerror_t int_delete( INameTree_t *cthis, cap_t obj, long name_offset, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);


	/* get the entry point */
	_ept = cthis->epts[MID_INT_DELETE - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, MID_INT_DELETE, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_DELETE - MID_INT_START] = _ept;
	}


	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

btcerror_t int_lookup( INameTree_t *cthis, cap_t obj, long name_offset, int ret_flags, int ret_offset, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((int *)_pb) = ret_flags;
	_pb += ((sizeof(int)/sizeof(void*)) + 1);
	*((int *)_pb) = ret_offset;
	_pb += ((sizeof(int)/sizeof(void*)) + 1);

	/* get the entry point */
	_ept = cthis->epts[MID_INT_LOOKUP - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, MID_INT_LOOKUP, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_LOOKUP - MID_INT_START] = _ept;
	}

	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

btcerror_t int_modify( INameTree_t *cthis, cap_t obj, long name_offset, long new_name_offset, long flags, long value, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = new_name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = flags;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = value;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);

	/* get the entry point */
	_ept = cthis->epts[MID_INT_MODIFY - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, MID_INT_MODIFY, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_MODIFY - MID_INT_START] = _ept;
	}

	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

btcerror_t int_rlookup( INameTree_t *cthis, cap_t obj, long name_offset, long start, long overflow, long recv_off, long recv_len, long num, long value, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = start;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = overflow;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = recv_off;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = recv_len;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = num;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = value;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);

	/* get the entry point */
	_ept = cthis->epts[MID_INT_RLOOKUP - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, MID_INT_RLOOKUP, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_RLOOKUP - MID_INT_START] = _ept;
	}

	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

btcerror_t int_fenum( INameTree_t *cthis, cap_t obj, long name_offset, long start, long overflow, long recv_off, long recv_len, long num, long value, environment_t *ev )
{
	entry_pt_t _ept;
	int _r;
	res_desc_t _res;
	btcerror_t _retval = 0;
	void **_pb;

	/* pack parameters into buffer */
	_pb = (void**)cthis->pb.address;
	*((cicap_t*)_pb) = cthis->ecicap;
	_pb += 2;
	*((cap_t *)_pb) = obj;
	_pb += ((sizeof(cap_t)/sizeof(void*)) + 1);
	*((long *)_pb) = name_offset;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = start;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = overflow;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = recv_off;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = recv_len;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = num;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);
	*((long *)_pb) = value;
	_pb += ((sizeof(long)/sizeof(void*)) + 1);

	/* get the entry point */
	_ept = cthis->epts[MID_INT_FENUM - MID_INT_START];
	if( _ept == NULL ) {
		_r = pax_cl_get_entry_pt( cthis->cid, IID_INAMETREE, 
					  MID_INT_FENUM, &_ept );
		if( _r != 0 ) {
			ev->_major = MCS_STUB_EXCEPTION;
			ev->_minor = _r;
			return _retval;
		}
		cthis->epts[MID_INT_FENUM - MID_INT_START] = _ept;
	}

	/* invoke the entry point */
	_r = pax_ci_request( _ept, cthis->pb, (res_desc_t*)&_res, PD_EMPTY );
	ev->_major = _res.type;
	ev->_minor = (_res.data1 >> 48);

	/* unpack the return value */
	_retval = (btcerror_t)_res.data1;

	/* return */
	return _retval;
}

/* Class-interface proxies */
INameTree_t *int_create_constructor( cid_t cid, cap_t pb, 
				     int size, environment_t *ev )
{
    INameTree_t *new_io;
    entry_pt_t ept;
    int r;
    res_desc_t res;
    
    /* clear the exception parameter */
    ev->_major = MCS_NO_EXCEPTION;
    
    /* allocate memory for the new interface object 
     * - legal error so no exception 
     */
    new_io = malloc( sizeof(INameTree_t) );
    if( new_io == NULL )
	return NULL;
    
    /* get the entry point for the constructor */
    r = pax_cl_get_entry_pt( cid, IID_CLASS_INTERFACE, 
			     MID_CI_CONSTRUCTOR, &ept );
    if( r != 0 ) {
	ev->_major = MCS_STUB_EXCEPTION;
	ev->_minor = r;
	goto error;
    }
    
    /* invoke the constructor */
    r = pax_ci_request( ept, pb, &res, PD_EMPTY );
    if( r != 0 ) {
	ev->_major = res.type;
	ev->_minor = (res.data1 >> 48);
	goto error;
    }
    
    /* fill in the interface object data */
    new_io->acicap.ref = (void*)(res.data0<<2);
    new_io->acicap.password = res.data1;
    new_io->ecicap = new_io->acicap;
    new_io->cid = cid;
    memset( new_io->epts, 0, sizeof(entry_pt_t)*MAX_EPTS );
    new_io->pb = pb;
    new_io->pb_size = size;

    /* done */
    return new_io;
    
 error:
    free( new_io );
    return NULL;
}

INameTree_t *int_cicap_constructor( cicap_t cicap, cap_t pb, int size, environment_t *ev )
{
	INameTree_t *new_io;

	/* clear the exception parameter */
	ev->_major = MCS_NO_EXCEPTION;

	/* allocate memory for the new interface object */
	new_io = malloc( sizeof(INameTree_t) );
	if( new_io == NULL )
		return NULL;

	/* fill in interface object */
	new_io->acicap = new_io->ecicap = cicap;
	new_io->cid = pax_cl_get_component_class( cicap );
	assert( new_io->cid != 0 );
	memset( new_io->epts, 0, sizeof(entry_pt_t)*MAX_EPTS );
	new_io->pb = pb;
	new_io->pb_size = size;

	/* done */
	return new_io;
}

void int_destructor( INameTree_t *cthis, environment_t *ev )
{
    int r;
    entry_pt_t ept;
    res_desc_t res;
    
    /* clear the exception parameter */
    ev->_major = MCS_NO_EXCEPTION;

    /* get the entry point for the destructor */
    r = pax_cl_get_entry_pt( cthis->cid, IID_CLASS_INTERFACE, MID_CI_DESTRUCTOR, &ept );
    if( r != 0 ) {
	ev->_major = MCS_STUB_EXCEPTION;
	ev->_minor = r;
	goto error;
    }
    
    /* call the component destructor */
    r = pax_ci_request( ept, *((cap_t*)&cthis->acicap), &res, PD_EMPTY );
    if( r != 0 ) {
	ev->_major = res.type;
	ev->_minor = (res.data1 >> 48);
	goto error;
    }

    /* delete the interface IO */
    free( cthis );
    error:
    ;
}

INameTree_t *int_get_typeinfo( INameTree_t *cthis, environment_t *ev )
{
	/* raise a NOT_IMPLEMENTED */
	ev->_major = MCS_STUB_EXCEPTION;
	ev->_minor = MCS_STE_NOTIMPLEMENTED;

	/* done */
	return cthis;
}

