/****************************************************************************
 *
 *      $Id: INameTree_io.h,v 1.2 2002/05/31 07:56:44 danielp Exp $
 *      Copyright (C) 2002 Operating Systems Research Group, UNSW, Australia.
 *
 *      This file is part of the Mungi operating system distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *	version 2 as published by the Free Software Foundation.
 *	A copy of this license is included in the top level directory of 
 *	the Mungi distribution.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 ****************************************************************************/

/***************************************************************************************************
 *
 * INameTree_io.h
 *
 * Definitions for the INameTree interface-object.
 * Autogenerated by PaxGen-0.1 on Tue Oct 23 11:42:46 2001
 *
 **************************************************************************************************/
#ifndef __INAMETREE_IO_H__
#define __INAMETREE_IO_H__


/* Includes */
#include "tree.h"

/* Interface constants */
#define IID_INAMETREE	0x69
#define MID_INT_START 	101
#define MID_INT_CREATE	101
#define MID_INT_DELETE	102
#define MID_INT_LOOKUP	103
#define MID_INT_MODIFY	104
#define MID_INT_RLOOKUP	105
#define MID_INT_FENUM	106
#define MID_INT_LAST 	106

/* Structure for the interface object */
typedef struct {
	cicap_t acicap, ecicap;
	cid_t cid;
	cap_t pb;
	int pb_size;
	entry_pt_t epts[10];
} INameTree_t;

/* Standard Interface Object Methods */
INameTree_t *int_create_constructor( cid_t cid, cap_t pb, int size, environment_t *ev );
INameTree_t *int_cicap_constructor( cicap_t cicap, cap_t pb, int size, environment_t *ev );
void int_destructor( INameTree_t *this, environment_t *ev );
#define int_get_cicap(cthis) (cthis->acicap)
#define int_get_pb(cthis)    (cthis->pb)

/* IDL defined methods */
btcerror_t int_create( INameTree_t *cthis, cap_t obj, long name_offset, 
		       long flags, long value, environment_t *ev );
btcerror_t int_delete( INameTree_t *cthis, cap_t obj, long name_offset, 
		       environment_t *ev );
btcerror_t int_lookup( INameTree_t *cthis, cap_t obj, long name_offset, 
		       int ret_flags, int ret_offset, environment_t *ev );
btcerror_t int_modify( INameTree_t *cthis, cap_t obj, long name_offset, 
		       long new_name_offset, long flags, long value, 
		       environment_t *ev );
btcerror_t int_rlookup( INameTree_t *cthis, cap_t obj, long name_offset, 
			long start, long overflow, long recv_off, 
			long recv_len, long num, long value, 
			environment_t *ev );
btcerror_t int_fenum( INameTree_t *cthis, cap_t obj, long name_offset, 
		      long start, long overflow, long recv_off, 
		      long recv_len, long num, long value, environment_t *ev );

#endif /* __INAMETREE_IO_H__ */
