/* Serial interface for L4 ipc L4/Linux systems, by Luke Deller (IBM)
   parts from ser-unix.c copyright 1992, 1993, 1994, 1998 Free Software Foundation, Inc. */

#include "defs.h"
#include "serial.h"
#include <fcntl.h>
#include <sys/types.h>
#include "terminal.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <l4/types.h>
#include <l4/ipc.h>
#include <services/lib/nameservice.h>
#include <services/lib/ipcpipe.h>

static int l4ipc_open PARAMS ((serial_t scb, const char *name));
static void l4ipc_raw PARAMS ((serial_t scb));
static int l4ipc_readchar PARAMS ((serial_t scb, int timeout));
static int l4ipc_setbaudrate PARAMS ((serial_t scb, int rate));
static int l4ipc_write PARAMS ((serial_t scb, const char *str, int len));
static void l4ipc_close PARAMS ((serial_t scb));
static serial_ttystate l4ipc_get_tty_state PARAMS ((serial_t scb));
static int l4ipc_set_tty_state PARAMS ((serial_t scb, serial_ttystate state));
static int l4ipc_noflush_set_tty_state PARAMS ((serial_t, serial_ttystate,
						   serial_ttystate));
static void l4ipc_print_tty_state PARAMS ((serial_t, serial_ttystate));
static int l4ipc_drain_output PARAMS ((serial_t));
static int l4ipc_flush_output PARAMS ((serial_t));
static int l4ipc_flush_input PARAMS ((serial_t));
static int l4ipc_send_break PARAMS ((serial_t));
static int l4ipc_setstopbits PARAMS ((serial_t, int));

void _initialize_ser_l4ipc PARAMS ((void));
static listener_stack[1024], speaker_stack[1024];
static ipcpipe_t ipcport;

static int
l4ipc_open(scb, name)
     serial_t scb;
     const char *name;
{
  l4_msgdope_t result;
  int ret, dum;
  l4_threadid_t remote_listener, remote_speaker;

  if (strlen(name) < 4)
    return -1;
  scb->fd = nameservice_get_service((char *)&name[3]).dw;
  if (scb->fd == 0 || scb->fd == -1)
    return -1;
  
  dbgprintf ("calling send\n");
  ret = l4_i386_ipc_send ((l4_threadid_t)(unsigned)scb->fd,
                          L4_IPC_SHORT_MSG, 0, 0x9db5e1, 0,
                          L4_IPC_TIMEOUT(128,9,128,9,6,6), &result);

  if (ret != 0)
    return -1;

  remote_listener = remote_speaker = (l4_threadid_t)(unsigned)scb->fd;
  remote_listener.id.lthread = 0x3c;
  remote_speaker.id.lthread = 0x3d;
  dbgprintf ("calling open\n");
  ipcpipe_open (&ipcport, remote_listener, remote_speaker, 0x3c, 0x3d, -1,
                &listener_stack[1020], &speaker_stack[1020]);
  dbgprintf ("sending ipc\n");
  ret = l4_i386_ipc_receive ((l4_threadid_t)(unsigned)scb->fd,
                             L4_IPC_SHORT_MSG, &dum, &dum, &dum,
                             L4_IPC_TIMEOUT(128,9,128,9,6,6), &result);
  dbgprintf ("returning\n");
  return ret ? -1 : 0;
}

static serial_ttystate
l4ipc_get_tty_state(scb)
     serial_t scb;
{
  return NULL;
}

static int
l4ipc_set_tty_state(scb, ttystate)
     serial_t scb;
     serial_ttystate ttystate;
{
  return 0;
}

static int
l4ipc_noflush_set_tty_state (scb, new_ttystate, old_ttystate)
     serial_t scb;
     serial_ttystate new_ttystate;
     serial_ttystate old_ttystate;
{
  return 0;
}

static void
l4ipc_print_tty_state (scb, ttystate)
     serial_t scb;
     serial_ttystate ttystate;
{
  return;
}

static int
l4ipc_return_0 (scb)
  serial_t scb;
{
  return 0;
}

static void
l4ipc_raw(scb)
     serial_t scb;
{
  return; /* always sending raw binary */
}

static int
l4ipc_readchar (scb, timeout)
     serial_t scb;
     int timeout;
{
#if 0
  unsigned dw1, dw2, dw3;
  int ret;
  l4_msgdope_t result;
  l4_threadid_t remote_id;
  remote_id.dw = scb->fd;
  ret = l4_i386_ipc_receive (remote_id, L4_IPC_SHORT_MSG, &dw1, &dw2, &dw3,
                             L4_IPC_TIMEOUT(128,9,128,9,6,6), &result);
  if (ret != 0) {
    if (result.md.error_code == 2 || result.md.error_code == 10)
      return SERIAL_TIMEOUT;
    else
      return SERIAL_ERROR;
  }
  if (dw2 != 0x9db)
    return SERIAL_ERROR;
  return (char)dw1;
#else
  return ipcpipe_getchar(&ipcport);
#endif
}

static int
l4ipc_write(scb, str, len)
     serial_t scb;
     const char *str;
     int len;
{
  int ret, i;
  l4_msgdope_t result;
  l4_threadid_t remote_id;
  remote_id.dw = scb->fd;

  for (i = 0; i < len; i++) {
#if 0
    ret = l4_i386_ipc_send (remote_id, L4_IPC_SHORT_MSG, str[i], 0x9db5e, 0,
                            L4_IPC_TIMEOUT(128,9,128,9,6,6), &result);
    if (ret != 0) {
      if (result.md.error_code == 2 || result.md.error_code == 10)
        return SERIAL_TIMEOUT;
      else
        return SERIAL_ERROR;
    }
#endif
    ipcpipe_putchar (&ipcport, str[i]);
  }
  return 0;
}

static void
l4ipc_close(scb)
     serial_t scb;
{
  scb->fd = -1;
}

static int
l4ipc_setbaudrate(scb, rate)
     serial_t scb;
     int rate;
{
  return 0;
}
 
static int
l4ipc_setstopbits(scb, num)
     serial_t scb;
     int num;
{
  return 0;
}
 
static struct serial_ops l4ipc_ops =
{
  "l4ipc",
  0,
  l4ipc_open,
  l4ipc_close,
  l4ipc_readchar,
  l4ipc_write,
  l4ipc_return_0,
  l4ipc_return_0,
  l4ipc_return_0,
  l4ipc_raw,
  l4ipc_get_tty_state,
  l4ipc_set_tty_state,
  l4ipc_print_tty_state,
  l4ipc_noflush_set_tty_state,
  l4ipc_setbaudrate,
  l4ipc_setstopbits,
  l4ipc_return_0,	/* wait for output to drain */
};

void
_initialize_ser_l4ipc ()
{
  nameservice_init();
  serial_add_interface (&l4ipc_ops);
}
