#include <services/lib/utils.h>
#include <services/lib/rm.h>
#include <services/client/rm.h>

int other_stack[2048];

void
other_main (void)
{
  sm_service_t rmservice;
  sm_exc_t exc;
  hprintf ("other thread alive\n");
  hprintf ("other thread is %x.%x\n", l4_myself().id.task,
           l4_myself().id.lthread);
  rmservice.dw = l4_myself().dw;
  rmservice.id.lthread = 0;
  rm_pgr_exit(rmservice, &exc);
  halt();
}

int
main (void)
{
  l4_threadid_t myself, mypager, mypreempter;
  unsigned dum;
  myself = l4_myself();
  mypager = mypreempter = L4_INVALID_ID;
  l4_thread_ex_regs (myself, -1, -1, &mypreempter, &mypager, &dum, &dum, &dum);
  hprintf ("main thread alive, I am %x.%x, my pager is %x.%x\n",
           myself.id.task, myself.id.lthread,
           mypager.id.task, myself.id.lthread);
  addRegion (mypager, 42, 0, 0xfffff000, 0, PF_R | PF_W);
  enter_kdebug ("trace ipc");
  create_thread (9, other_main, &other_stack[2046], l4_myself());
  rm_main_thread(0);
  return -1; /* unreachable */
}

