#include <services/lib/ld.h>
#include <services/client/fileprov.h>
#include <services/lib/nameservice.h>
#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#undef BYTE_ORDER
#include <stdio.h>
#include <sys/param.h>
#include <unistd.h>
#include <stdlib.h>
#include <services/lib/utils.h>

int
main (int argc, char *argv[])
{
  sm_service_t fileproviderService;
  sm_exc_t exc;
  dataspace_t exesource;
  int ret, debug;
  char resolved_path[MAXPATHLEN];
  if ((argc > 2) && !strcmp(argv[1], "-g")) {
    argc--;
    debug = 1;
  } else
    debug = 0;
  if ((argc != 2) || (realpath(argv[1+debug], resolved_path) == NULL)) {
    printf ("usage: runl4 [-g] <exefilename>\n");
    exit(1);
  }
  nameservice_init();
  fileproviderService = nameservice_get_service("fileprov");
  if (l4_is_invalid_id(fileproviderService)) {
    printf ("runl4: couldn't find fileprovider\n");
    exit(1);
  }
  fileprov_dm_open(fileproviderService, resolved_path, &exesource.dsid, &exc);
  if (exc._type != 0) {
    printf ("runl4: trouble opening file: %s\n", resolved_path);
    exit(1);
  }
  exesource.dsm = fileproviderService.dw;
  dbgprintf("runl4: calling run_elf()\n");
  ret = run_elf(exesource, debug);
  if (ret < 0)
    printf ("runl4: run_elf() returned error code %d\n", ret);
  else {
    printf ("runl4: new task is running with task number 0x%x\n", ret);
    if (debug)
      printf ("runl4: now run our gdb and give it the command "
              "`target remote l4-%x'\n", ret);
  }
  return 0;
}

