#include <l4/ipc.h>
#include <l4/kernel.h>
#include <l4/types.h>
#include <l4/syscalls.h>
#include <stdio.h>
#include <services/client/dm_anon.h>
#include <services/lib/nameservice.h>

/* #define RMGR_NAME_SERVICE */

l4_threadid_t rmgr_id;

void
handle_exception(sm_exc_t *ev)
{
    switch (ev->_type) {
	case exc_dm_anon_no_descriptor:
	    printf("dm_anon exception: No descriptor\n");
	    break;
	case exc_dm_anon_no_memory:
	    printf("dm_anon exception: No memory\n");
	    break;
	case exc_dm_anon_invalid_handle:
	    printf("dm_anon exception: Invalid handle\n");
	    break;
	case exc_dm_anon_no_free_page:
	    printf("dm_anon exception: No free page\n");
	    break;
    }
    return;
}

int
main(void)
{
    sm_service_t dm_anon;
    sm_exc_t ev;
    dsid_t ds_handle_1, ds_handle_2;
    unsigned long *addr1 = (unsigned long *)0xb0000000;
    unsigned long *addr2 = (unsigned long *)0xb0001000;
    unsigned long *addr3 = (unsigned long *)0xb0002000;
    unsigned long *addr4 = (unsigned long *)0xb0006000;
    l4_snd_fpage_t fpage;
    dword_t paddr;

    /* Lookup anon dm */
    nameservice_init();
    dm_anon = nameservice_get_service("dm_anon");
#ifdef RMGR_NAME_SERVICE
    if (rmgr_init()) {
	printf("test_dm_anon: rmgr found at %x.%x\n",
	       rmgr_id.id.task, rmgr_id.id.lthread);
    } else {
	printf("test_dm_anon: rmgr not found");
	exit(-1);
    }

    if (rmgr_get_task_id("dm_anon", &dm_anon) == 0) {
	printf("test_dm_anon: dm_anon found at %x.%x\n",
	       dm_anon.id.task, dm_anon.id.lthread);
    } else {
	printf("test_dm_anon: dm_anon not found");
	enter_kdebug("test_dm_anon");
    }
#endif /* RMGR_NAME_SERVICE */

    dm_anon_ds_open(dm_anon, &ds_handle_1, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: open failed\n");
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: open %d\n", ds_handle_1);
    }

    dm_anon_ds_map_page(dm_anon, l4_fpage((unsigned long)addr1,
			L4_LOG2_PAGESIZE, 0, 0),
			ds_handle_1, 0, &fpage, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: map page <%d, 0x%x> failed\n",
	       ds_handle_1, 0);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: map page <%d, 0x%x>\n",
	       ds_handle_1, 0);
    }

    dm_anon_ds_map_page(dm_anon, l4_fpage((unsigned long)addr2,
			L4_LOG2_PAGESIZE, 0, 0),
			ds_handle_1, 0x1000, &fpage, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: map page <%d, 0x%x> failed\n",
	       ds_handle_1, 0x1000);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: map page <%d, 0x%x>\n",
	       ds_handle_1, 0x1000);
    }

    printf("test_dm_anon: *addr1 %d (should be 0), *addr2 %d (0)\n",
	   *addr1, *addr2);
    *addr1 = 6;
    *addr2 = 7;
    printf("test_dm_anon: *addr1 %d (should be 6), *addr2 %d (7)\n",
	   *addr1, *addr2);

    dm_anon_ds_open_contig(dm_anon, &ds_handle_2, 14, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: open failed\n");
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: open %d\n", ds_handle_2);
    }

    dm_anon_ds_map_page(dm_anon, l4_fpage((unsigned long)addr3, 14, 0, 0),
			ds_handle_2, 0, &fpage, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: map page <%d, 0x%x> failed\n",
	       ds_handle_2, 0);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: map page <%d, 0x%x>\n",
	       ds_handle_2, 0);
    }

    dm_anon_ds_map_page(dm_anon, l4_fpage((unsigned long)addr4, 14, 0, 0),
			ds_handle_2, 0x2000, &fpage, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: map page <%d, 0x%x> failed\n",
	       ds_handle_2, 0x4000);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: map page <%d, 0x%x>\n",
	       ds_handle_2, 0x4000);
    }

    printf("test_dm_anon: *addr3 %d (should be 0), *addr4 %d (0)\n",
	   *addr3, *addr4);
    *addr3 = 3;
    *addr4 = 4;
    printf("test_dm_anon: *addr3 %d (should be 3), *addr4 %d (4)\n",
	   *addr3, *addr4);

    dm_anon_ds_paddr(dm_anon, ds_handle_1, 0, &paddr, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: paddr <%d, 0x%x> failed\n",
	       ds_handle_1, 0);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: paddr <%d, 0x%x> = 0x%x\n",
	       ds_handle_1, 0, paddr);
    }

    dm_anon_ds_paddr(dm_anon, ds_handle_2, 0x2000, &paddr, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: paddr <%d, 0x%x> failed\n",
	       ds_handle_2, 0x4000);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: paddr <%d, 0x%x> = 0x%x\n",
	       ds_handle_2, 0x4000, paddr);
    }

    dm_anon_ds_close(dm_anon, ds_handle_1, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: close failed %d\n", ds_handle_1);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: close %d\n", ds_handle_1);
    }

#if 0
    dm_anon_ds_close(dm_anon, ds_handle_1, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: close failed %d\n", ds_handle_1);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: close %d\n", ds_handle_1);
    }
#endif /* 0 */

    dm_anon_ds_close(dm_anon, ds_handle_2, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: close %d failed\n", ds_handle_2);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: close %d\n", ds_handle_2);
    }

#if 0
    dm_anon_ds_close(dm_anon, ds_handle_2, &ev);
    if (ev._type != exc_l4_no_exception) {
	printf("test_dm_anon: close %d failed\n", ds_handle_2);
	handle_exception(&ev);
    } else {
	printf("test_dm_anon: close %d\n", ds_handle_2);
    }
#endif /* 0 */
}
