#ifndef __elfexe_h__
#define __elfexe_h__

#include <l4/types.h>
#include <services/lib/decodelf.h>

typedef unsigned       Elf32_Addr;
typedef unsigned short Elf32_Half;
typedef unsigned       Elf32_Off;
typedef signed         Elf32_Sword;
typedef unsigned       Elf32_Word;

#define EI_NIDENT 16
#ifndef NULL
#define NULL ((void *) 0)
#endif

typedef struct {
  unsigned char e_ident [EI_NIDENT];
  Elf32_Half    e_type;
  Elf32_Half    e_machine;
  Elf32_Word    e_version;
  Elf32_Addr    e_entry;
  Elf32_Off     e_phoff;
  Elf32_Off     e_shoff;
  Elf32_Word    e_flags;
  Elf32_Half    e_ehsize;
  Elf32_Half    e_phentsize;
  Elf32_Half    e_phnum;
  Elf32_Half    e_shentsize;
  Elf32_Half    e_shnum;
  Elf32_Half    e_shstrndx;
} Elf32_Ehdr;

#define ET_NONE  0
#define ET_RELOC 1
#define ET_EXEC  2
#define ET_DYN   3
#define ET_CORE  4

#define EM_386   3

typedef struct {
  Elf32_Word    p_type;
  Elf32_Off     p_offset;
  Elf32_Addr    p_vaddr;
  Elf32_Addr    p_paddr;
  Elf32_Word    p_filesz;
  Elf32_Word    p_memsz;
  Elf32_Word    p_flags;
  Elf32_Word    p_align;
} Elf32_Phdr;

#define PT_NULL    0
#define PT_LOAD    1
#define PT_DYNAMIC 2
#define PT_INTERP  3
#define PT_NOTE    4
#define PT_SHLIB   5
#define PT_PHDR    6

#define PF_X        0x00000001
#define PF_W        0x00000002
#define PF_R        0x00000004
#define PF_MASKPROC 0xf0000000

typedef struct segmentDesc_s segmentDesc_t;
struct segmentDesc_s {
  void *srcbase;
  unsigned destbase;
  unsigned memsize, filesize;
  int access;
  segmentDesc_t *next;
};

int
verifyElfFormat (void *elfFile);
     /* returns nonzero if *elfFile is not an elf file appropriate for 
      * loading */

segmentDesc_t *
buildSegmentList (void *elfFile, segmentDesc_t *elfSegments, 
                  int *p_numElfSegments, unsigned *entry);
     /* returns a linked list of loadable program segment descriptors,
      * or NULL on error */

#endif

