/*
 * At some point, we need to standardize our crt0.  Right now I use 3
 * flavors:
 *
 * (1) No crt0.  Get a stack from the region mapper and set the entry
 * point to main.  The region mapper calls main and then cleans up
 * when main returns.
 * (2) crt0 for SawMill apps started by runl4.  Set up a stack in
 * crt0 and jump to main.  The entry point is _start.  The region
 * mapper calls _start and then cleans up when main returns.  The
 * stack area is set up using the .space directive in crt0 or as an
 * array.  Define SAWMILL_LOADED for this crt0.
 * (3) crt0 for SawMill apps started by GRUB.  Set up a stack in crt0
 * and call main.  The entry point is _start.  After returning from
 * main, you sleep forever.  Define GRUB_LOADED for this crt0.
 *
 * Right now, the lthreads library counts on the stack being a single
 * page.  The top is &_stack.  The bottom is &_stack - 4096.
 */
#define GRUB_LOADED
	.text
	.global _start
	.global _stext
	.global _stack
_stext:	
_start:
#ifdef SAWMILL_LOADED
	popl	%eax
	leal	_stack, %esp
	pushl	%eax
	/* pushl ___return_from_main */
	jmp	main
#endif /* SAWMILL_LOADED */
#ifdef GRUB_LOADED
	leal	_stack, %esp
	call	main
	/* Sleep forever */
	movl	$-1,%eax
	xorl	%ecx,%ecx
	xorl	%ebp,%ebp
	xorl	%esi,%esi
	int	$0x30
#endif /* GRUB_LOADED */

	.align 16, 0x90
__mb_header:
	.long   0x1BADB002;
	.long   0x00010000;
	.long   - 0x00010000 - 0x1BADB002;
	.long   __mb_header;
	.long   _start;
	.long   _edata;
	.long   _end;
	.long   _start;

	.bss

	.space 4096
_stack:
