/*
 * Copyright (c) 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef _flick_link_all_h_
#define _flick_link_all_h_

/******************************************************************************
 ******************************************************************************
 ****
 **** Typedef's for internal types which Flick-generated code may use.  (See
 **** `c/libpres_c/mint_to_ctype_name.cc'.)
 ****
 ******************************************************************************
 *****************************************************************************/

/*
 * On BSD, <sys/types.h> defines `{u_,}int{8,16,32}_t' through inclusion of
 * <machine/machtypes.h>.  But there's no corresponding set of types for SysV?
 *
 * #include <sys/types.h>
 */

/* the server skeleton sends this to the runtime handler after executing
   an operation requested by a client.
*/
typedef enum
{
	FLICK_OPERATION_FAILURE         = 1,    /* The operation did not execute properly or completely */
	FLICK_OPERATION_SUCCESS         = 2,    /* The operation executed completely, and a reply must be sent */
	FLICK_OPERATION_SUCCESS_NOREPLY = 3,    /* The operation executed completely, but no reply should be sent

						   (e.g. oneway) */
	FLICK_OPERATION_PROPAGATING     = 4     /* The operation was a propagation */
} flick_operation_success_t;


typedef		char		flick_signed8_t;
typedef		unsigned char	flick_unsigned8_t;
typedef		short		flick_signed16_t;
typedef		unsigned short	flick_unsigned16_t;
typedef		int		flick_signed32_t;
typedef		unsigned int	flick_unsigned32_t;

typedef		char		flick_char8_t;
/* typedef	w_char		flick_char16_t; */

typedef		float		flick_float32_t;
typedef		double		flick_float64_t;

/* I hate non-posix reallocs... */
#define nonposix_realloc(pointer, sz) ((pointer) ? realloc(pointer, sz) : malloc(sz))
#define t_malloc(type, count) (type *)malloc((count) * sizeof(type))
#define t_calloc(type, count) (type *)calloc(count, sizeof(type))
#define t_realloc(ptr, type, count) (type *)nonposix_realloc(ptr, (count) * sizeof(type))

#endif /* _flick_link_all_h_ */

/* End of file. */

