/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef __flick_link_trapeze_h
#define __flick_link_trapeze_h
#define TRAPEZE
#include <lanai_device.h>
#include <mcp.h>
#include <user_tpz.h>
#include <mcp_memory.h>
#include <tpz_api.h>

#include <flick/link/all.h>

#define CLIENT __OLD_CLIENT
#include <rpc/rpc.h>
#undef CLIENT
#ifndef RPCGEN

#define TRAPEZE_MAX_CONTROL_SIZE  112
#define TRAPEZE_MAX_PAYLOAD_SIZE 8192
#define PAGE_COUNT 16

extern int flick_seqnum;

/* MUST BE SET TO THE PATH NAME FOR "mcp.dat".
   `trapeze_orb_boa.c' has default location. */
extern char *mcp_filename;

/* the free receive DBLOCK for the server. This is for swapping payloads. */
/* this is defined in trapeze_orb_boa.c */
extern int flick_trapeze_server_free_recv_buf;

// caddr_t _buf_start;    /* start of current message */
// void *_buf_current;   /* position in current message */
// What should *flick_marshal_stream_t be (if anything)?
typedef tpz_msgbuf_t FLICK_BUFFER;
typedef void *flick_marshal_stream_t;

void trapeze_mcp_init(int is_server);
	
void *flick_trapeze_client_array__alloc();
void  flick_trapeze_client_array__free(void *payload_ptr);
void *flick_trapeze_server_array__alloc();

#ifdef FLICK_PROTOCOL_TRAPEZE_ONC
typedef struct flick_client_struct svc_req;

/****** ONC message format macros ******/
/* Used for both client request & server reply... */
#define flick_trapeze_build_message_header(_obj, msg_type)	\
	/* little endian flag... */				\
	((char *)_buf_start)[0] = 1;				\
	((char *)_buf_start)[1] = msg_type;			\
	((short *)_buf_start)[1] = (_obj)->host;		\
	((int *)_buf_start)[1] = htonl((_obj)->u.header.xid);		\
	((int *)_buf_start)[2] = htonl((_obj)->u.header.dir);		\
	((int *)_buf_start)[3] = htonl((_obj)->u.header.rpcvers);	\
	((int *)_buf_start)[4] = htonl((_obj)->u.header.prog);		\
	((int *)_buf_start)[5] = htonl((_obj)->u.header.vers);		\
        flick_trapeze_goto_message_body()		       

#define flick_trapeze_get_prog_and_vers(prog, vers)	\
	prog = ntohl(((int *)_buf_start)[4]);			\
	vers = ntohl(((int *)_buf_start)[5]);

#define flick_trapeze_goto_message_body()			\
	_buf_current = &((int *)_buf_start)[6]

#ifdef VERIFY
/* Used for both client reply & server request... */
#define flick_trapeze_verify_message_header(msg_type) {		\
	if  (ntohl(((int *)_buf_start)[2]) != msg_type)		\
		fprintf(stderr, "Malformed Message Header!\n");	\
}
#else
#define flick_trapeze_verify_message_header(msg_type)
#endif
/****** End of ONC specific macros ******/

#else
#ifndef FLICK_PROTOCOL_TRAPEZE
#define FLICK_PROTOCOL_TRAPEZE
#endif

/****** Trapeze (pseudo IIOP) message format macros ******/
/* Used for both client request & server reply... */
#define flick_trapeze_build_message_header(_obj, msg_type)	\
	/* little endian flag... */				\
	((char *)_buf_start)[0] = 1;				\
	((char *)_buf_start)[1] = msg_type;			\
	((short *)_buf_start)[1] = (_obj)->host;		\
        flick_trapeze_goto_message_body()		       

#define flick_trapeze_goto_message_body()			\
	_buf_current = (void *) ((int *)_buf_start + 2)

#ifdef VERIFY
/* Used for both client reply & server request... */
#define flick_trapeze_verify_message_header(msg_type) {		\
	if  (((char *)_buf_start)[1] != msg_type)		\
		fprintf(stderr, "Malformed Message Header!\n");	\
}
#else
#define flick_trapeze_verify_message_header(msg_type)
#endif
/****** End of Trapeze (pseudo IIOP) specific macros ******/
#endif


/* Initialization / Exit code */
#define flick_trapeze_client_start_encode() {				    \
	_msg_buf = tpz_get_sendmsg_spinwait();				    \
	if (!_msg_buf) {						    \
		fprintf(stderr,						    \
			"Can't get send message buffer from trapeze!\n");   \
		exit(1);						    \
	}								    \
	_buf_start = tpz_mtod(_msg_buf);				    \
        /* Request = 0 */					    \
	flick_trapeze_build_message_header(_obj, 0);	  	    \
	flick_trapeze_goto_message_body();			    \
}

#define flick_trapeze_client_end_encode() /* Nothing to do. */

#define flick_trapeze_client_start_decode() {			\
	_buf_start = tpz_mtod(_msg_buf);			\
        /* Reply = 1 */						\
	flick_trapeze_verify_message_header(1);		\
	flick_trapeze_goto_message_body();		\
}

#define flick_trapeze_client_end_decode()	\
        tpz_release_rcvmsg(_msg_buf);


/*
 * Server-side macros
 */

#define flick_trapeze_server_start_decode() {			\
	_replytoken = CTRL_MSG;					\
	_this_obj->dest = ((short *)_buf_start)[1];		\
        /* Request = 0 */					\
	flick_trapeze_verify_message_header(0);	\
	flick_trapeze_goto_message_body();		\
}

#define flick_trapeze_server_end_decode()	\
	tpz_release_rcvmsg(_msg_buf);	      


#define flick_trapeze_server_restart_encode()				\
	flick_trapeze_goto_message_body();
	
#define flick_trapeze_server_start_encode() {				\
        _msg_buf = tpz_get_sendmsg_spinwait();				\
	_buf_start = tpz_mtod(_msg_buf);				\
        /* Reply = 1 */							\
	flick_trapeze_build_message_header(_this_obj, 1);	\
	flick_trapeze_goto_message_body();			\
}

#define flick_trapeze_server_end_encode() {	 \
        tpz_aim(_msg_buf, _this_obj->dest, _replytoken); \
	tpz_release_sendmsg(_msg_buf);			 \
}

/* Globbing & Chunking code */
#define flick_trapeze_encode_new_glob(max_size)			\
        if ((char *)_buf_current + (max_size) >			\
	    (char *)_buf_start + TRAPEZE_MAX_CONTROL_SIZE)	\
		fprintf(stderr, "Control buffer overflow!\n");

#define flick_trapeze_encode_end_glob(max_size)/* We don't do squat */
#define flick_trapeze_encode_new_chunk(size)	/* Don't do anything */
#define flick_trapeze_encode_end_chunk(size)	\
	((char *)_buf_current) += (size);
#define flick_trapeze_encode_new_chunk_align(size, final_bits,		\
                                             init_bits, init_ofs) {	\
	unsigned int _align = (1 << (final_bits)) - 1;			\
	_buf_current =							\
		(void *)(((unsigned int)((char *)_buf_current + _align))\
			 & ~_align);					\
}

#define flick_trapeze_encode_new_glob_plain(max_size)	\
        flick_trapeze_encode_new_glob(max_size)
#define flick_trapeze_encode_end_glob_plain(max_size)	\
	flick_trapeze_encode_end_glob(max_size)
#define flick_trapeze_encode_new_chunk_plain(size)	\
	flick_trapeze_encode_new_chunk(size)
#define flick_trapeze_encode_end_chunk_plain(size)	\
	flick_trapeze_encode_end_chunk(size)

#define flick_trapeze_decode_new_glob(max_size) /* We don't do squat */
#define flick_trapeze_decode_end_glob(max_size)	/* Again - do nothing */
#define flick_trapeze_decode_new_chunk(size)	/* Fait rien */
#define flick_trapeze_decode_end_chunk(size)	\
	_buf_current += size;
#define flick_trapeze_decode_new_chunk_align(size, final_bits,		\
                                             init_bits, init_ofs) {	\
	unsigned int _align = (1 << (final_bits)) - 1;			\
	_buf_current =							\
		(void *)(((unsigned int)((char *)_buf_current + _align))\
			  & ~_align);					\
}

/* The following stuff probably belongs in corba_on_trapeze.h */

#define flick_trapeze_cdr_client_encode_target(_obj)		\
	(int)((int *)_buf_start)[1] = (_obj)->u.info.key;
#define flick_trapeze_xdr_client_encode_target(_obj)

#define flick_trapeze_client_encode_target(_obj, _ofs, ENCNAME)	\
	flick_trapeze_##ENCNAME##_client_encode_target(_obj);
#define flick_trapeze_client_decode_target(_obj, _ofs, ENCNAME)
#define flick_trapeze_server_encode_target(_obj, _ofs, ENCNAME)
#define flick_trapeze_server_decode_target(_obj, _ofs, ENCNAME)	\
	(_obj) = _this_obj;

#define _BYTESWAPSHORT(a) ((a >> 8) | (a << 8))

#define _BYTESWAPLONG(a) ((a >> 24) |			\
			  ((a & 0x00FF0000) >> 8 ) |	\
			  ((a & 0x0000FF00) << 8 ) |	\
			  (a << 24))

#define _BYTESWAPHYPER(a) ((a >> 56) |				\
			   ((a & 0x00FF000000000000LL) >> 40) |	\
			   ((a & 0x0000FF0000000000LL) >> 24) |	\
			   ((a & 0x000000FF00000000LL) >> 8) |	\
			   ((a & 0x00000000FF000000LL) << 8) |	\
			   ((a & 0x0000000000FF0000LL) << 24) |	\
			   ((a & 0x000000000000FF00LL) << 40) |	\
			   (a << 56))

#define flick_trapeze_array_swap16(_ptr, _size) {			\
	int _i;								\
	for (_i = 0; _i < (_size)/2; _i++) {				\
		(long)(((long *)(_ptr))[_i]) =				\
			_BYTESWAPSHORT((long)(((long *)(_ptr))[_i]));	\
	}								\
}

#define flick_trapeze_array_swap32(_ptr, _size) {			\
	int _i;								\
	for (_i = 0; _i < (_size)/4; _i++) {				\
		(long)(((long *)(_ptr))[_i]) =				\
			_BYTESWAPLONG((long)(((long *)(_ptr))[_i]));	\
	}								\
}

#define flick_trapeze_array_swap64(_ptr, _size) {			\
	int _i;								\
	for (_i = 0; _i < (_size)/4; _i++) {				\
		(long)(((long *)(_ptr))[_i]) =				\
			_BYTESWAPHYPER((long)(((long *)(_ptr))[_i]));	\
	}								\
}

#define flick_trapeze_client_encode_array(_array_ptr, _size) {		\
	tpz_attach_sendmsg(_msg_buf,					\
			   (vm_offset_t)				\
			   ((int)(DBLOCK[0]) +				\
			    ((int)(_array_ptr) - (int)(UBLOCK[0]))),	\
			   0 /* No callback function */, 0);		\
	tpz_set_payload_len(_msg_buf, (_size));				\
}


#define flick_trapeze_client_decode_array(_array_ptr, _size)		\
	(void *)(_array_ptr) = (void *)					\
		((int)(UBLOCK[0]) +					\
		 (tpz_detach_rcvmsg(_msg_buf) - (int)(DBLOCK[0])))

#define flick_trapeze_server_encode_array(_array_ptr, _size) {		\
	tpz_attach_sendmsg(_msg_buf,					\
			   (vm_offset_t)				\
			   ((int)(DBLOCK[0]) +				\
			    ((int)(_array_ptr) - (int)(UBLOCK[0]))),	\
			   0 /* No callback function */, 0);		\
	tpz_set_payload_len(_msg_buf, (_size));				\
}

#define flick_trapeze_server_decode_array(_array_ptr, _size) {		\
	int _tmp = (tpz_detach_rcvmsg(_msg_buf) - (int)(DBLOCK[0]));	\
	(void *)(_array_ptr) = (void *)					\
		((int)(UBLOCK[0]) + _tmp);				\
        tpz_attach_rcvmsg(						\
                _msg_buf,						\
		(vm_offset_t) ((int)(DBLOCK[0]) + PAGE_SIZE *		\
			       flick_trapeze_server_free_recv_buf));	\
        flick_trapeze_server_free_recv_buf = (_tmp / PAGE_SIZE);	\
}

#define flick_trapeze_mu_encode_array(_array_ptr, _size)
#define flick_trapeze_mu_decode_array(_array_ptr, _size)

#define flick_trapeze_mark_port_for_cleanup(a, b)

typedef struct flick_client_struct *FLICK_CLIENT;

#define _typedef___FLICK_SERVER
typedef flick_operation_success_t (*FLICK_SERVER)(FLICK_BUFFER,
						  caddr_t,
						  FLICK_CLIENT);
typedef int mom_server_t(FLICK_BUFFER, FLICK_BUFFER *);


/****** Corba specific definitions ******/
typedef int CORBA_ReferenceData;

#include <flick/pres/corba.h>

struct CORBA_BOA_type {
        char *OAid;
        int count_servers;
        FLICK_CLIENT refs;
        CORBA_ORB orb;
};

struct CORBA_ORB_type {
        CORBA_BOA boas[1];
        int OA_count;
        char *ORBid;
};

typedef struct Object_info {
	CORBA_BOA boa;
        CORBA_ReferenceData key;
	const char *type_id; /* considered a constant literal string */
	unsigned int type_id_len; /* strlen(typeid) */
} Object_info;
/****** End of Corba specific definitions ******/

/****** Sun specific definitions ******/
#include <flick/pres/sun.h>

typedef struct call_header {
	unsigned long xid;
	unsigned long dir;
	unsigned long rpcvers;
	unsigned long prog;
	unsigned long vers;
} call_header;

typedef struct FLICK_SERVER_DESCRIPTOR {
  unsigned int prog_num;
  unsigned int vers_num;
  struct sockaddr_in addr;
} FLICK_SERVER_DESCRIPTOR;
/****** End of Sun specific definitions ******/

/****** MOM specific definitions ******/
typedef FLICK_CLIENT mom_ref_t;
/****** End of MOM specific definitions ******/


typedef struct flick_client_struct {
	unsigned int dest;
	unsigned int host;
        FLICK_SERVER server_func; 
	union {
		call_header header; /* for SUN/ONC */
		Object_info info;   /* for CORBA */
	} u;	
} FLICK_CLIENT_STRUCT;

typedef flick_operation_success_t flick_dispatch_t(FLICK_BUFFER, caddr_t,
						   FLICK_CLIENT);

int flick_trapeze_client_rpc_receiving_payload(
        FLICK_CLIENT in_cli, FLICK_BUFFER *_msg_buf,
	tpz_msgspec_t specifier, void *out_payload_buf);
int flick_trapeze_client_rpc(FLICK_CLIENT in_cli,
			     FLICK_BUFFER *_msg_buf, tpz_msgspec_t specifier);
int flick_trapeze_client_send(FLICK_CLIENT in_cli,
			      FLICK_BUFFER _msg_buf, tpz_msgspec_t specifier);
int flick_trapeze_server_get_request(FLICK_BUFFER *_msg_buf);

/* should never be called.  It is handled by end_decode */
int flick_trapeze_server_send_reply(
        FLICK_BUFFER _msg_buf, tpz_msgspec_t specifier);

void flick_trapeze_server_send_exception(FLICK_BUFFER _msg_buf,
					 const char *exception_type);

char *find_system_exception_id(char *name, int size);
	
#if 0
/*
 * Runtime marshal/unmarshal functions.
 */
void         flick_cdr_encode_IOR_internal(void *_buf_current,
					   FLICK_CLIENT obj,
					   const char *link,
					   int ref_adjust);
FLICK_CLIENT flick_cdr_decode_IOR_internal(flick_marshal_stream_t stream,
					   int cdr_swap,
					   const char *link,
					   int ref_adjust);
#endif /* #if 0 */

#ifdef FLICK_PROTOCOL_TRAPEZE_ONC

/* This is the first attempt at a generic flick runtime.  It's patterned
   after the Sun RPC transport, right now (cuz that's what it's going to
   be used for
   */

/* This one _can_ be used to register servers
   (if they want to build their own main function)
   */
int	flick_server_register(FLICK_SERVER_DESCRIPTOR, FLICK_SERVER);

/* This one _can_ be used to begin grabbing messages
   (if they want to build their own main function)
   */
void	flick_server_run();

#endif /* #ifdef FLICK_PROTOCOL_TRAPEZE_ONC */

#endif  /* #ifndef RPCGEN */

#endif /* __flick_link_trapeze_h */

/* End of file. */
