/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef __flick_pres_mom_h
#define __flick_pres_mom_h

#define PRESNAME mom

#include <flick/pres/all.h>

#include <oskit/c/errno.h>
#include <oskit/c/sys/types.h>

typedef struct mom_exc_t {
	int _type;
	void *_except;
} mom_exc_t;

/*
 * The Fluke allocator, invoked by the Fluke presentation generator.
 */
#define mom_flick_alloc(a) (malloc(a))
#define mom_flick_free(a) (free(a))

/* These are all the error macros */
#define exc_mom_no_exception (0)
#define exc_mom_system_exception (-1)

#define flick_mom_init_environment()		\
{						\
	_ev->_type = exc_mom_no_exception;	\
}

#define flick_mom_encode_system_exception(loc, ENCNAME, LINKNAME)	\
{									\
	flick_##LINKNAME##_encode_new_chunk(4);				\
	flick_##ENCNAME##_encode_signed32(0, (int) ((loc)->_except));	\
	flick_##LINKNAME##_encode_end_chunk(4);				\
}

#define flick_mom_decode_system_exception(loc, ENCNAME, LINKNAME)	\
{									\
	flick_##LINKNAME##_decode_new_chunk(4);				\
	flick_##ENCNAME##_decode_signed32(0, (int) ((loc)->_except));	\
	flick_##LINKNAME##_decode_end_chunk(4);				\
}

#define flick_mom_server_error(retname, errval, ENCNAME, LINKNAME, START)\
{									\
	flick_##LINKNAME##_server_##START##_encode();			\
	flick_##LINKNAME##_encode_new_glob_plain(8);			\
	flick_##LINKNAME##_encode_new_chunk_plain(8);			\
	flick_##ENCNAME##_encode_signed32(0, exc_mom_system_exception);	\
	flick_##ENCNAME##_encode_signed32(4, (int) (errval));		\
	flick_##LINKNAME##_encode_end_chunk_plain(8);			\
	flick_##LINKNAME##_encode_end_glob_plain(8);			\
	flick_##LINKNAME##_server_end_encode();				\
	retname;							\
}

#define flick_mom_encode_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_mom_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, restart)

#define flick_mom_decode_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_mom_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, start)

#define flick_mom_memory_server_error(retname, errval, ENCNAME, LINKNAME) \
	flick_mom_server_error(retname, EINVAL, ##ENCNAME, ##LINKNAME, start)

/* The client errors are easy - just set the value, and return */
#define flick_mom_encode_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_mom_system_exception;				  \
        _ev->_except = (void *) EINVAL;					  \
	retname;							  \
}

#define flick_mom_decode_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_mom_system_exception;				  \
	_ev->_except = (void *) EIO;					  \
	retname;							  \
}

#define flick_mom_memory_client_error(retname, errval, ENCNAME, LINKNAME) \
{									  \
	_ev->_type = exc_mom_system_exception;				  \
        _ev->_except = (void *) EINVAL;					  \
	retname;							  \
}

/* These things are pretty brain-dead right now... */
#define flick_mom_encode_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("MOM/Fluke", "encode", "stub")
#define flick_mom_decode_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("MOM/Fluke", "decode", "stub")
#define flick_mom_memory_mu_error(retname, errval, ENCNAME, LINKNAME) \
	flick_error("MOM/Fluke", "other", "stub")

#endif /* __flick_pres_mom_h */

/* End of file. */
	
