/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef __flick_pres_sun_h
#define __flick_pres_sun_h

#include <flick/pres/all.h>
#include <errno.h>

/* if not working over Sun/TCP, we still need the definition of svc_req */
#ifndef __flick_link_suntcp_h
#define CLIENT __OLD_CLIENT
#include <rpc/rpc.h>
#undef CLIENT
#endif

/* may already be defined from <flick/link/suntcp.h> */
#ifndef _typedef___FLICK_SERVER_LOCATION
#define _typedef___FLICK_SERVER_LOCATION
typedef struct FLICK_SERVER_LOCATION {
  char *server_name;
  unsigned int prog_num;
  unsigned int vers_num;
} FLICK_SERVER_LOCATION;
#endif

/* FLICK_CLIENT, not sun_flick_client, should be used in the link layer */
typedef struct flick_client_struct *sun_flick_client;
typedef struct flick_client_struct CLIENT;

/* This one must be used by the client to open a connection to the server */
int	flick_client_create(sun_flick_client, FLICK_SERVER_LOCATION);

#define create_client(clnt, srvr) {			\
	int success = flick_client_create(clnt, srvr);	\
	assert(success);				\
}

/* This one must be used by the client to close a connection to the server */
void	flick_client_destroy(sun_flick_client);


/* The sun allocator - BFD */
#define sun_flick_alloc(a) malloc(a)
#define sun_flick_free(a) free(a)

/* Stuff for the sun presentation */
#define flick_errno errno

#define flick_sun_init_environment()		\
	flick_errno = 0;

/* The sun exceptions don't contain any data - XXX */
#define flick_sun_encode_system_exception(errval, _enc_name, _link_name) {}

#define flick_sun_decode_system_exception(errval, _enc_name, _link_name) {}

#define flick_sun_server_error(retname, errval, _enc_name, _link_name, START)\
{									\
	flick_##_link_name##_server_##START##_encode();			\
	flick_##_link_name##_encode_new_glob_plain(4);			\
	flick_##_link_name##_encode_new_chunk_plain(4);			\
	flick_##_enc_name##_encode_signed32(0, -1);			\
	flick_##_link_name##_encode_end_chunk_plain(4);			\
	flick_##_link_name##_encode_end_glob_plain(4);			\
	flick_##_link_name##_server_end_encode();			\
	retname;							\
}

#define flick_sun_encode_server_error(retname, errval, _enc_name, _link_name) \
	flick_sun_server_error(retname, errval, ##_enc_name, ##_link_name,    \
			       restart)

#define flick_sun_decode_server_error(retname, errval, _enc_name, _link_name) \
	flick_sun_server_error(retname, errval, ##_enc_name, ##_link_name,    \
			       start)
#define flick_sun_memory_server_error(retname, errval, _enc_name, _link_name) \
	flick_sun_server_error(retname, errval, ##_enc_name, ##_link_name,    \
			       start)

#define flick_sun_encode_client_error(retname, errval, _enc_name, _link_name) \
{									      \
	errno = EINVAL;							      \
	retname;							      \
}

#define flick_sun_decode_client_error(retname, errval, _enc_name, _link_name) \
{									      \
	errno = EIO;							      \
	retname;							      \
}

#define flick_sun_memory_client_error(retname, errval, _enc_name, _link_name) \
{									      \
	errno = EINVAL;							      \
	retname;							      \
}

/* These things are pretty brain-dead right now... */
#define flick_sun_encode_mu_error(retname, errval, _enc_name, _link_name) \
	flick_error("sun", "encode", "stub")
#define flick_sun_decode_mu_error(retname, errval, _enc_name, _link_name) \
	flick_error("sun", "decode", "stub")
#define flick_sun_memory_mu_error(retname, errval, _enc_name, _link_name) \
	flick_error("sun", "other", "stub")

#endif /* __flick_pres_sun_h */

/* End of file. */

