/* page cloning library .. needed for implementation of copy-on-write */

#ifndef __COW_H__
#define __COW_H__

typedef unsigned copy_id_t; /* for making several copies of a page, this
                               identifies one such copy.  It could correspond
                               to taskid of client, for example */

void *
get_page_copy (void *orig_page, copy_id_t copy_id);
/* Returns a copy of the original page.  Only one copy is ever made per
   copy_id. */

void *
get_zeroed_copy (void *vaddr, copy_id_t copy_id);
/* Like get_page_copy, but the page is initialised with zeroes rather than
   with a copy of an original page */

void *
get_partial_page_copy (void *orig_page, copy_id_t copy_id,
                       unsigned num_bytes_to_copy);
/* Returns a page containing a copy of the first `num_bytes_to_copy' bytes of
   the original page.  The remainder of the returned page is zero-initialised.
   Only one copy is ever made per copy_id. */

void
dealloc_copies(copy_id_t copy_id);
/* deallocate all the pages associated with one copy_id (eg with one client) */

#endif  /* moo */

