#ifndef __LIB_RM_H__
#define __LIB_RM_H__

#include <services/lib/decodelf.h>
#include <services/client/rm.h>
#include <services/client/genericdm.h>

typedef struct combuf_s {
  l4_threadid_t dsmgr;
  unsigned objId, start, size, dsoffset, access;
} combuf_t;

#ifndef PF_R
#define PF_R 0x00000004
#endif
#ifndef PF_W
#define PF_W 0x00000002
#endif

void
rm_main_thread(int fwdUnknownPfaults);

extern int rm_stack[1024];
extern dataspace_t rm_init_ds;

/* wrapper functions for calling region mapper */
static combuf_t *combuffer = NULL;
static sm_service_t rmservice;

static __inline__ void
attach_region (const dataspace_t *exesource, unsigned regionstart,
               unsigned regionsize, unsigned dsoffset, unsigned access)
{
  sm_exc_t exc;
  if (combuffer == NULL) {
    rmservice = l4_myself();
    rmservice.id.lthread = 0;
    rm_pgr_getbuf (rmservice, (sdword_t*)&combuffer, &exc);
  }
  combuffer->dsmgr.dw = exesource->dsm;
  combuffer->objId = exesource->dsid;
  combuffer->start = regionstart;
  combuffer->size = regionsize;
  combuffer->access = access;
  rm_pgr_attach(rmservice, &exc);
}
 
static __inline__ void
detach_region (unsigned regionstart)
{
  sm_exc_t exc;
  if (combuffer == NULL) {
    rmservice = l4_myself();
    rmservice.id.lthread = 0;
    rm_pgr_getbuf (rmservice, (sdword_t*)&combuffer, &exc);
  }
  combuffer->start = regionstart;
  rm_pgr_detachregion(rmservice, &exc);
}
 
static __inline__ void
detach_dataspace (const dataspace_t *ds)
{
  sm_exc_t exc;
  if (combuffer == NULL) {
    rmservice = l4_myself();
    rmservice.id.lthread = 0;
    rm_pgr_getbuf (rmservice, (sdword_t*)&combuffer, &exc);
  }
  combuffer->dsmgr.dw = ds->dsm;
  combuffer->objId = ds->dsid;
  rm_pgr_detachdataspace(rmservice, &exc);
}

typedef void (*startstop_fn_t) (l4_threadid_t threadid, int starting);
/* call with starting = 1 when a thread is just started */
/* call with starting = 0 when a thread is stopping */
/* this fn must be called by the thread which is starting/stopping */

typedef const char *(*getinfo_fn_t) (l4_threadid_t threadid, int whatinfo);
/* called by gdbstub for an active threadid */
/* whatinfo = 4: return string describing thread's state (eg suspended) */
/* whatinfo = 8: return string containing thread's name */
/* whatinfo = 16: return string containing other info (whatever you like) */

#endif
