
#ifndef __L4_TYPESL4X_H__ 
/* #define __L4_VERSION_X__ */
#include <l4/types.h>
#include <l4/kdebug.h>
#endif

typedef unsigned long LnThread;
typedef unsigned long sm_handle_t;

typedef struct {
  unsigned index:24;
  unsigned version:8;
} sm_next_struct;


typedef union {
  unsigned long value;
  sm_next_struct s;
} sm_next;


typedef struct SM_HANDLE {
  LnThread owner;
  unsigned perms;
  void *obj;
  sm_next next;
} sm_handle;


typedef struct {
  sm_handle *data;
  unsigned size;
  unsigned used;
  sm_handle *low_free;
  sm_handle *high_free;
} sm_handle_table;


#define SM_HANDLE_MASK     0xFFFFFF
#define SM_HANDLE_VERSION_MASK 0xFF000000
#define SM_HANDLE_VERSIONS     256
#define SM_HANDLE_VOFFSET      24

#define SM_INVALID_OWNER       (LnThread) L4_INVALID_ID.dw

//#define DEBUG 1
#ifdef DEBUG
#define DPRINTF(S)  printf S
#else
#define DPRINTF(S)
#endif


extern sm_handle_table *sm_ht;
extern char *sm_malloc(int size);

#define SM_HANDLE_PTR(h) ((sm_handle *) ((sm_ht) ? (((h) & SM_HANDLE_MASK) + sm_ht->data) : 0))

#define SM_USED(t, h) (((t)) && ((t)->data[((h) & SM_HANDLE_MASK)].owner != L4_INVALID_ID))


/* sm_handle_table exists and address of handle is within the 
   data of its handle_table */


     /*  
#define AUTHORIZE_SM_HANDLE_EQOP(h, o, op) \
((((unsigned) ((MY_TASKID((l4_threadid_t) ((h)->owner))).dw)) == \
  ((unsigned) ((MY_TASKID((o))).dw))) && \
  ((h)->perms == (op)))
*/

#define SM_PTR_TO_INDEX(t, p) ((((t)) && ((p) >= (t)->data) && \
                               ((p) < ((t)->data + (t)->size))) ? \
                 (((unsigned) (p) - (unsigned) (t)->data) / sizeof(sm_handle)) : \
                 -1)


#define SM_HANDLE_TO_INDEX(h) ((h) & SM_HANDLE_MASK)


#define INDEX_TO_SM_HANDLE(i,v) ((i) | ((v) << SM_HANDLE_VOFFSET))  


#define SM_HANDLE_ACTIVE(h) \
     ((sm_ht) && (((h) & SM_HANDLE_MASK) < ((sm_ht)->size)) && \
      ((sm_ht)->data[(h) & SM_HANDLE_MASK].owner != (unsigned) L4_INVALID_ID.dw))


/*  replace with server-defined malloc
#ifdef LINUX
#define sm_malloc(size) malloc((size))
#elif NO_DSM
#define sm_malloc(size) smh_malloc((size))
#else
#define sm_malloc(size) malloc((size))
#endif
*/



/* SM_HANDLE error codes  */

#define SM_OK 0
#define SM_HANDLE_ILLEGAL_INDEX -1
#define SM_HANDLE_SYS_ALLOC -2
#define SM_HANDLE_TABLE_SIZE -3
#define SM_HANDLE_SYS_INIT -4
#define SM_HANDLE_SET_UNUSED -5
#define SM_HANDLE_INVALID (sm_handle_t) -1




/* functions sm_handle_sys.c */
extern sm_handle_t new_sm_handle (LnThread, unsigned, void *);
extern int initialize_sm_handle_system (int);
extern int reinitialize_sm_handle_system (int);
extern int used_handles_sm_handle (void);
extern int max_handles_sm_handle (void);
extern sm_handle *min_max_handles_sm_handle (void);
extern sm_handle_t new_sm_handle (LnThread, unsigned, void *);
extern sm_handle_t free_sm_handle (sm_handle_t);

/* functions sm_handle.c */
extern int set_owner_sm_handle (sm_handle_t, LnThread);
//extern LnThread owner_sm_handle (sm_handle *);
extern int set_permissions_sm_handle(sm_handle_t, unsigned);
//extern unsigned permissions_sm_handle (sm_handle *);
extern int set_attached_obj_sm_handle(sm_handle_t, void *);
//extern void *attached_obj_sm_handle (sm_handle *);
extern sm_handle_t new_alias_sm_handle (sm_handle_t, LnThread, unsigned);
extern sm_handle_t set_alias_sm_handle (sm_handle_t, sm_handle_t);
//extern sm_handle_t next_alias_sm_handle (sm_handle *);
//extern LnThread next_sm_handle_owned_by (sm_handle *);



/* WARNING: Must use after ACTIVE_HANDLE */ 

inline static unsigned permissions_sm_handle (sm_handle *h) {
  return h->perms;
}


inline static LnThread owner_sm_handle (sm_handle *h) {
  return h->owner;
}


inline static void *attached_obj_sm_handle (sm_handle *h) {
  return h->obj;
}


inline static sm_handle_t next_alias_sm_handle (sm_handle *h) {
  return (sm_handle_t) h->next.value;
}


inline static LnThread next_sm_handle_owned_by (sm_handle *h) {
  sm_handle_t next;
  if ((next = (sm_handle_t) h->next.value)) return SM_HANDLE_PTR(next)->owner;
  return 0;
}



/* NOTE: Should implement an atomic read -- or a new function is needed */
inline static int read_sm_handle(sm_handle_t h, sm_handle *hptr) {
  if (((((unsigned) h & SM_HANDLE_VERSION_MASK) >> SM_HANDLE_VOFFSET) == 
       SM_HANDLE_PTR(h)->next.s.version)) {
    memcpy(hptr, SM_HANDLE_PTR(h), 16);
    /*
    hptr->owner = SM_HANDLE_PTR(h)->owner;
    hptr->perms = SM_HANDLE_PTR(h)->perms;
    hptr->obj = SM_HANDLE_PTR(h)->obj;
    hptr->next.value = SM_HANDLE_PTR(h)->next.value;
    */
    return SM_OK;
  }
  else {
    printf("read: handle id version: %d; handle version: %d\n", 
	   (((unsigned) h & SM_HANDLE_VERSION_MASK) >> SM_HANDLE_VOFFSET),
	   SM_HANDLE_PTR(h)->next.s.version);
  }
  return SM_HANDLE_INVALID;
}




/* NOTE: Should be an L4 function */
static __inline__ l4_threadid_t
MY_TASKID(l4_threadid_t tid)
{
    l4_threadid_t newtid;

    newtid = tid;
    newtid.id.lthread = 0;
    return newtid;
}



inline static sm_handle_t next_sm_handle_of_task(sm_handle_t h, LnThread t) 
{
  sm_handle *hptr = SM_HANDLE_PTR(h);
  int i;

  l4_threadid_t owner;
  l4_threadid_t th;

  owner.dw =  hptr->owner;
  th.dw = t;

  for (i = SM_HANDLE_TO_INDEX(h); i < sm_ht->size; i++, hptr++) {
    if (MY_TASKID(owner).dw == MY_TASKID(th).dw) {
      return INDEX_TO_SM_HANDLE(i, hptr->next.s.version);
    }
  }
  return (sm_handle_t) -1;
}




/* NOTE: Move to the authorization library */
/* NOTE: May also authorize by thread or equality of operation */
static __inline__ int
AUTHORIZE_SM_HANDLE_BITOP(sm_handle *h, l4_threadid_t o, unsigned op) 
{
  l4_threadid_t newtid;
  unsigned t1, t2;

  newtid.dw = h->owner;
  
  t1 = (unsigned) MY_TASKID(newtid).dw;
  t2 = (unsigned) MY_TASKID(o).dw;

  DPRINTF(("authorize: t1: 0x%x; t2 0x%x; p 0x%x; op 0x%x\n",
	 t1, t2, h->perms, op));

  return ((t1 == t2) && (h->perms & op));
}



static __inline__ void
dump_sm_handle(sm_handle_t h)
{
  sm_handle *hptr = SM_HANDLE_PTR(h);
  printf(">>> handle: address 0x%x; index: %d\n
          owner: 0x%x; obj: 0x%x; perms: 0x%x; next: 0x%x\n",
	 (unsigned) hptr, SM_HANDLE_TO_INDEX(h), 
	 (unsigned) hptr->owner, (unsigned) hptr->obj, hptr->perms, 
	 hptr->next.value);
}



static __inline__ void
dump_all_sm_handles()
{
  int i;
  sm_handle *hptr;
  
  for (i = 0; i < sm_ht->size; i++) {
    hptr = sm_ht->data + i;
    if (SM_HANDLE_ACTIVE(i))
      printf(">>> handle: address 0x%x; index %d\n", (unsigned) hptr, i);
      printf("handle: owner: 0x%x; obj: 0x%x; perms: 0x%x; next: 0x%x\n",
	     (unsigned) hptr->owner, (unsigned) hptr->obj, hptr->perms, 
	     hptr->next.value);
  }
}
