#include <l4/ipc.h>
#include <l4/kdebug.h>
#include <l4/kernel.h>
#include <l4/syscalls.h>
#include <l4/types.h>
#include <services/lib/queue.h>

/*
 * thread_t
 */
typedef dword_t thread_t;

#define OWNER_MASK	0x00000ff
#define WAIT_QUEUE_MASK	0x0000100
#define NOTIFY_ONE_MASK	0x0000200
#define NOTIFY_ALL_MASK	0x0000400

/*
 * l4_threadid_t
 */
struct params {
    thread_t t;
    dword_t  stack_low;
    dword_t  stack_high;
    dword_t  eip;
    dword_t  back_ptr;
};
typedef struct params *params_t;

/*
 * Special thread ids
 */
#define TH_NIL_ID	-1
#define REGION_MAPPER	0
#define EMUL_LIB	1
#define SERIALIZER	2
#define GDB_THREAD	3
#define IPC_PIPE_SEND	4
#define IPC_PIPE_RECV	5
#define RESERVED_1	6
#define RESERVED_2	7
#define FIRST_THREAD	8

/*
 * TCB allocation
 */
#define MAX_TCBS 128

extern l4_threadid_t serializer;
extern int highest_used_tcb;
 
struct tcb {
    dword_t       stack_low;
    dword_t       stack_high;
    dword_t       eip;
    dword_t       back_ptr;
    int           suspend;
    int           susp_depth;
#define NO_QUEUE 0
#define EXTERNAL 1
#define INTERNAL 2
    int           queue;
    int           mon_wait;
    queue_chain_t monq;
    int           mon_depth;
    int           mon_count;
    int           priority;
    thread_t      next;
};
typedef struct tcb *tcb_t;

struct tcb thk_tcb[MAX_TCBS];

#define tcb(x)    (thk_tcb[x])
#define tcb_th(x) (((char *)(x) - (char *)&thk_tcb[0]) / \
                   sizeof(struct tcb))

/*
 * Monitor
 */
struct mon {
    thread_t      owner;
    int           count;
    queue_head_t  ext_queue;
    queue_head_t  int_queue;
    queue_chain_t monq;
};
typedef struct mon *mon_t;

/*
 * Misc
 */
#define SYS_OK      0
#define SYS_ERR     -1
#define SYS_DELAYED -2

extern void wait_for_resume(void);
extern int valid_used(thread_t);
extern int valid_unused(thread_t);
extern void alloc_stack(thread_t, int);
extern thread_t free_tcb(void);
extern void use_tcb(thread_t);
extern void unuse_tcb(thread_t);
extern void execute_notifications(mon_t);
extern thread_t new_thread(thread_t);

extern l4_threadid_t l4_thread(thread_t);

/*
 * th_*
 */
#define STACK_POINTER 0
#define STACK_LOW     1
#define STACK_HIGH    2

extern thread_t th_init(void);
extern thread_t th_create(thread_t, dword_t, dword_t, dword_t, dword_t);
extern void th_exit_self(void);
extern int th_suspend(thread_t);
extern int th_suspend_carefully(thread_t);
extern int th_suspended(thread_t);
extern int th_resume(thread_t);
extern dword_t th_stack(thread_t, int);
extern int th_back_ptr(thread_t, dword_t *);
extern void th_yield(thread_t);
extern thread_t th_thread_self(void);
extern int th_priority(thread_t, dword_t *);

/*
 * mon_*
 */
#define NOTIFY_ONE 0
#define NOTIFY_ALL 1

extern void mon_init(mon_t);
extern int mon_enter(mon_t);
extern int mon_entered(mon_t);
extern int mon_exit(mon_t);
extern int mon_notify(mon_t, int);
extern int mon_wait(mon_t, int);

/*
 * thk_*, serialized calls
 */
extern void thk_create(thread_t);
extern void thk_exit_self(int);
extern void thk_suspend(thread_t);
extern void thk_susp_carefully(thread_t);
extern void thk_resume(thread_t);
extern void thk_enter(mon_t);
extern void thk_enter_after_wait(mon_t);
extern void thk_exit(mon_t);
extern void thk_wait(mon_t);
