/* Miscellaneous useful stuff */

#ifndef __utils_h__
#define __utils_h__

#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/ipc.h>
#include <stdarg.h>

typedef short lock_t;
#define __atomic_fool_gcc(x) (*(volatile struct { int a[100]; } *)x)

#ifndef NULL
#define NULL ((void *) 0)
#endif

int hvsprintf(char *buf, const char *fmt, va_list args);
int hsprintf(char *buf, const char *fmt, ...);

#ifdef __DEBUG__
#define dbgprintf hprintf
#else
static __inline__ int dbgprintf(const char *fmt, ...) {return 0;}
#endif

int hprintf(const char *fmt, ...);

static __inline__ l4_threadid_t
TASKID(l4_threadid_t tid)
{
  l4_threadid_t newtid;
  newtid = tid;
  newtid.id.lthread = 0;
  return newtid;
}

typedef struct cp_resource_s {
  l4_threadid_t consumer, producer;
  int items, spots;
} cp_resource_t;

static __inline__ void
init_consume_produce (cp_resource_t *cp,
                      l4_threadid_t consumer, l4_threadid_t producer,
                      unsigned bufsize)
{
  cp->consumer = consumer;
  cp->producer = producer;
  cp->items = 0;
  cp->spots = bufsize - 1;
}

static __inline__ void
consume (cp_resource_t *cp) /* put this just before consumption */
{
  char minusflag, zeroflag;
  l4_msgdope_t md;
  unsigned dummy;
  l4_threadid_t me;
  me = l4_myself();
  dbgprintf ("%x.%x:wanna consume\n", me.id.task, me.id.lthread);
  asm ("incl	%1\n\t"
       "setz	%0"
       : "=g"(zeroflag)
       : "m"(cp->spots));
  if (zeroflag)
    l4_i386_ipc_send (cp->producer, L4_IPC_SHORT_MSG, 0, 0, 0,
                      L4_IPC_NEVER, &md);
  asm ("decl	%1\n\t"
       "sets	%0"
       : "=g"(minusflag)
       : "m"(cp->items));
  if (minusflag)
    l4_i386_ipc_receive (cp->producer, L4_IPC_SHORT_MSG, &dummy,&dummy,&dummy,
                         L4_IPC_NEVER, &md);
  dbgprintf ("%x.%x:consuming\n", me.id.task, me.id.lthread);
}

static __inline__ void
produce (cp_resource_t *cp) /* put this just after production */
{
  char minusflag, zeroflag;
  l4_msgdope_t md;
  unsigned dummy;
  l4_threadid_t me;
  me = l4_myself();
  dbgprintf ("%x.%x:produced\n", me.id.task, me.id.lthread);
  asm ("incl	%1\n\t"
       "setz	%0"
       : "=g"(zeroflag)
       : "m"(cp->items));
  if (zeroflag)
    l4_i386_ipc_send (cp->consumer, L4_IPC_SHORT_MSG, 0, 0, 0,
                      L4_IPC_NEVER, &md);
  asm ("decl	%1\n\t"
       "sets	%0"
       : "=g"(minusflag)
       : "m"(cp->spots));
  if (minusflag)
    l4_i386_ipc_receive (cp->consumer, L4_IPC_SHORT_MSG, &dummy,&dummy,&dummy,
                         L4_IPC_NEVER, &md);
}

static __inline__ void 
enter_lock (volatile lock_t *lock)
{ /* FIXME */
  register int r;
  int timeout = 0;
  do {
    while (*lock > 0) {
      unsigned dum;
      l4_msgdope_t result;
      l4_i386_ipc_receive (L4_NIL_ID, L4_IPC_SHORT_MSG, &dum, &dum, &dum,
                           L4_IPC_TIMEOUT(128,13,128,13,6,6), &result);
      timeout++;
      if (timeout > 5000) {
        enter_kdebug ("enter_lock: locked out");
      }
    }
    asm volatile ("xchg %0,(%1)\n\t":"=r"(r):"r"(lock),"0"(1));
  } while (r > 0);
}

static __inline__ void 
leave_lock (lock_t *lock)
{
  *lock = 0;
}

static __inline__ void 
create_thread (int lthread, void (*start)(void), void *stack,
	       l4_threadid_t pager)
{
  l4_threadid_t destid, ourpreempter, ourpager;
  dword_t dummy;
  destid = l4_myself();
  ourpager = ourpreempter = L4_INVALID_ID;
  l4_thread_ex_regs (destid, (dword_t)-1, (dword_t)-1, &ourpreempter,
		     &ourpager, &dummy, &dummy, &dummy);
  if (pager.dw == L4_INVALID_ID.dw)
    pager = ourpager;

  destid.id.lthread = lthread;
  dbgprintf("create_thread: destid = 0x%x, pager = 0x%x\n",
          destid.dw, pager.dw);
  l4_thread_ex_regs (destid, (dword_t) start, (dword_t) stack,
		     &ourpreempter, &pager, &dummy, &dummy, &dummy);
}

static __inline__ void 
create_thread_with_param (int lthread, void (*start)(int), void *stack,
	                  l4_threadid_t pager, int param)
{
  l4_threadid_t destid, ourpreempter, ourpager;
  dword_t dummy;
  destid = l4_myself();
  ourpager = ourpreempter = L4_INVALID_ID;
  l4_thread_ex_regs (destid, (dword_t)-1, (dword_t)-1, &ourpreempter,
		     &ourpager, &dummy, &dummy, &dummy);
  if (pager.dw == L4_INVALID_ID.dw)
    pager = ourpager;

  destid.id.lthread = lthread;
  *--(int*)stack = param;
  --(int*)stack;
  dbgprintf("create_thread: destid = 0x%x, pager = 0x%x\n",
          destid.dw, pager.dw);
  l4_thread_ex_regs (destid, (dword_t) start, (dword_t) stack,
		     &ourpreempter, &pager, &dummy, &dummy, &dummy);
}

static __inline__ void
halt (void)
{
  l4_msgdope_t result;
  dword_t dummy;
  l4_i386_ipc_receive (L4_NIL_ID, L4_IPC_SHORT_MSG, &dummy, &dummy, &dummy,
                       L4_IPC_NEVER, &result);
}

#endif

