// -*- c++ -*-

#ifndef ATOMIC_H
#define ATOMIC_H

class simple_lock_t
{
public:
  bool test_and_set();
  void clear();
  void set();
  bool test();
private:
  int my_lock;
};

//
// inline stuff
//

// atomic operations
template <class I>
inline bool compare_and_swap(I *ptr, I oldval,
			     I newval)
{
  char ret;

  asm volatile
    ("cmpxchgl %1,(%2) \n"
     " sete %%al"
     : "=a" (ret)
     : "q" (newval), "q" (ptr), "0" (oldval)
     : "memory");

  return ret;
}

template <class I>
inline bool test_and_set(I *l)
{
  int tmp;

  asm volatile
    ("xchg %0,%1" : "=r" (tmp) : "m" (*l), "0" (1)
     : "memory");

  return tmp;
}


// simple_lock_t

#if 0
inline bool simple_lock_t::test_and_set()
{
  int tmp;

  asm volatile
    ("xchg %0,%1" : "=r" (tmp) : "m" (my_lock), "0" (1));

  return tmp;
}
#else
inline bool simple_lock_t::test_and_set()
{
  return ::test_and_set(&my_lock);
}
#endif


inline void simple_lock_t::clear()
{
  my_lock = 0;
}

inline void simple_lock_t::set()
{
  my_lock = 1;
}

inline bool simple_lock_t::test()
{
  return my_lock;
}

// XXX

#endif
