// -*- c++ -*-

#ifndef CONFIG_H
#define CONFIG_H

#define THREAD_BLOCK_SIZE (0x800)

#ifndef ASSEMBLER

#include <termios.h>
#include <flux/tty.h>

#include <l4/types.h>

class config
{
public:
  // initialization
  static void init();

  // global kernel configuration
  static const kernel_version_id = 0x01004444; // "DD\000\001"

  static const char *const kernel_version_string = 
    "Welcome to Fiasco!\n"
    "DD-L4/x86 microkernel (c) 1998 TU Dresden - " __DATE__;
  // don't change the part "DD-L4/x86 microkernel" -- Rmgr depends on it.

  static const unsigned kernel_mem_per_cent = 20;

  static const unsigned thread_block_size = THREAD_BLOCK_SIZE;

  static const unsigned thread_block_mask = (thread_block_size - 1);
  static const unsigned thread_block_id_factor = thread_block_size/0x400;
  
  static const backward_compatibility = false;
  static const hlt_works_ok = true;

  static const conservative = true;

  static bool use_hercules, use_serial;

  static termios* const serial_termios = &base_raw_termios;
  static unsigned serial_com_port;

#ifdef PROFILE
  static bool profiling;
#else
  static const profiling = false;
#endif
  static const profiling_rate = 100;

  // kernel (idle) task definitions
  static const unsigned kernel_taskno = 0;
  static const l4_threadid_t kernel_id = L4_NIL_ID;
  static const kernel_prio = 1, kernel_mcp = 255;
  
  // sigma0 task definitions
  static const unsigned sigma0_taskno = 2;
  static const l4_threadid_t sigma0_id 
    = ((l4_threadid_t){id:{0, 0, sigma0_taskno, 0, 0, 0, 0}});
  static const sigma0_prio = 0x10, sigma0_mcp = 0;

  // root (boot) task definitions
  static const unsigned boot_taskno = 4;
  static const l4_threadid_t boot_id 
    = ((l4_threadid_t){id:{0, 0, boot_taskno, 0, 0, 0, 0}});
  static const boot_prio = 0x10, boot_mcp = 255;

  // default number of clock ticks / time slice
  static const default_time_slice = 10;
  // one clock tick takes this many microsecs
  static const microsec_per_tick = 976LL;
};

#endif /* ! ASSEMBLER */

#endif
