#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "kmem.h"

#include "config.h"

void 
config::init()
{
  if (strstr(kmem::cmdline(), "hercules"))
    use_hercules = true;

  // serial i/o
  serial_termios->c_ispeed = serial_termios->c_ospeed = B115200; // default

  char *s;
  if ((s = strstr(kmem::cmdline(), " -comspeed ")))
    {
      unsigned n = strtoul(s + 11, 0, 0);
      if (n)
	serial_termios->c_ispeed = serial_termios->c_ospeed = n;
      else
	printf("invalid com speed -- defaulting to %ld\n", 
	       serial_termios->c_ospeed);
    }

  if ((s = strstr(kmem::cmdline(), " -comport ")))
    {
      unsigned n = strtoul(s + 10, 0, 0);
      if (n && n >= 1 && n <= 2)
	serial_com_port = n;
      else
	printf("invalid com port -- defaulting to %d\n", serial_com_port);
    }

  if (strstr(kmem::cmdline(), " -VT") || strstr(kmem::cmdline(), " -serial"))
    use_serial = true;

#ifdef PROFILE
  if (strstr(kmem::cmdline(), " -profile"))
    profiling = true;
#endif
}
