/* -*- c -*- */
/* large parts of the code copied from
   oskit/libkern/x86/base_trap_inittab */

/* 
 * Mach Operating System
 * Copyright (c) 1993,1992,1991,1990 Carnegie Mellon University
 * Copyright (c) 1991 IBM Corporation 
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation,
 * and that the nema IBM not be used in advertising or publicity 
 * pertaining to distribution of the software without specific, written
 * prior permission.
 * 
 * CARNEGIE MELLON AND IBM ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON AND IBM DISCLAIM ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * This file contains a 'gate_init' initialization table
 * to initialize the x86 processor trap vectors to default entrypoints.
 * These entrypoints simply push a standard trap_state frame
 * and jump to the 'trap_handler' routine.
 */

#define ASSEMBLER

#include <flux/x86/asm.h>
#include <flux/x86/eflags.h>
#include <flux/x86/trap.h>
#include <flux/x86/seg.h>
#include <flux/x86/gate_init.h>
#include <flux/x86/base_trap.h>

#include "config.h"
#include "kmem.h"

/*
 * No error code.  Clear error code and push trap number.
 */
#define	EXCEPTION(n,name)					\
	GATE_ENTRY(n,name,ACC_PL_K | ACC_TRAP_GATE)		;\
name:								;\
	pushl	$(0)						;\
	pushl	$(n)						;\
	jmp	slowtraps

/*
 * User-accessible exception.  Otherwise, same as above.
 */
#define	EXCEP_USR(n,name)					\
	GATE_ENTRY(n,name,ACC_PL_U | ACC_TRAP_GATE)		;\
name:								;\
	pushl	$(0)						;\
	pushl	$(n)						;\
	jmp	slowtraps

/*
 * Error code has been pushed.  Just push trap number.
 */
#define	EXCEP_ERR(n,name)					\
	GATE_ENTRY(n,name,ACC_PL_K | ACC_TRAP_GATE)		;\
name:								;\
	pushl	$(n)						;\
	jmp	slowtraps


GATE_INITTAB_BEGIN(idt_init_table)

EXCEPTION(0x00,t_zero_div)
EXCEPTION(0x01,t_debug)
EXCEP_USR(0x03,t_int3)
EXCEP_USR(0x04,t_into)
EXCEP_USR(0x05,t_bounds)
EXCEPTION(0x06,t_invop)
EXCEPTION(0x07,t_nofpu)
EXCEP_ERR(0x08,a_dbl_fault)
EXCEPTION(0x09,a_fpu_over)
EXCEP_ERR(0x0a,a_inv_tss)
EXCEP_ERR(0x0b,t_segnp)
EXCEP_ERR(0x0c,t_stack_fault)
EXCEP_ERR(0x0d,t_gen_prot)
/* EXCEP_ERR(0x0e,t_page_fault) */
EXCEPTION(0x0f,t_trap_0f)
EXCEPTION(0x10,t_fpu_err)
EXCEP_ERR(0x11,t_align)
EXCEPTION(0x12,t_trap_12)
EXCEPTION(0x13,t_trap_13)
EXCEPTION(0x14,t_trap_14)
EXCEPTION(0x15,t_trap_15)
EXCEPTION(0x16,t_trap_16)
EXCEPTION(0x17,t_trap_17)
EXCEPTION(0x18,t_trap_18)
EXCEPTION(0x19,t_trap_19)
EXCEPTION(0x1a,t_trap_1a)
EXCEPTION(0x1b,t_trap_1b)
EXCEPTION(0x1c,t_trap_1c)
EXCEPTION(0x1d,t_trap_1d)
EXCEPTION(0x1e,t_trap_1e)
EXCEPTION(0x1f,t_trap_1f)

slowtraps:

	/* Save the rest of the state frame.
	   Note that on the 486 and up,
	   pusha is slower than the equivalent set of manual pushes,
	   so don't do this in your own code if you want speed.
	   For our purposes here we're more worried
	   about size and simplicity...  */
	pusha

slow_2:	/* entry point if regs have already been saved */
	pushl	%ds
	pushl	%es
	pushl	%fs
	pushl	%gs

	/* Load the kernel's segment registers.  */
	movw	%ss,%ax
	movw	%ax,%ds
	movw	%ax,%es

	/* GCC likes the direction flag cleared.  */
	cld

        /* Call the C handler function if one has been installed.  */
        movl    EXT(base_trap_handler),%eax
        orl     %eax,%eax
        jz      1f
        pushl   %esp
        call    *%eax
        popl    %edx

	/* If the handler function returned zero (success),
	   then resume execution as if the trap never happened.
	   Otherwise, just panic.  */
	orl	%eax,%eax
	jnz	1f

	popl	%gs
	popl	%fs
	popl	%es
	popl	%ds
	popa
	addl	$4*2,%esp	/* Pop trap number and error code */
	iret

1:
	/* Dump the register state and panic.  */
	UNEXPECTED_TRAP

/* some more macro definitions */

#define SAVE_STATE				\
	pushl	%ebp				;\
	pushl	%ebx				;\
	pushl	%edi				;\
	pushl	%esi				;\
	pushl	%edx				;\
	pushl	%ecx

#define RESTORE_STATE				\
	popl	%ecx				;\
	popl	%edx				;\
	popl	%esi				;\
	popl	%edi				;\
	popl	%ebx				;\
	popl	%ebp				;\

#define RESET_KERNEL_SEGMENTS			\
	movw	$ (GDT_DATA_USER|SEL_PL_U), %cx	;\
	movw	%ds,%dx				;\
	cmpw	%cx,%dx				;\
	jz	1f				;\
	movw	%cx,%ds				;\
1:	movw	%es,%dx				;\
	cmpw	%cx,%dx				;\
	jz	1f				;\
	movw	%cx,%es				;\
1:

#define RESET_USER_SEGMENTS			\
	movw	$ (GDT_DATA_USER|SEL_PL_U), %cx	;\
	movw	%fs,%dx				;\
	cmpw	%cx,%dx				;\
	jz	1f				;\
	movw	%cx,%fs				;\
1:	movw	%gs,%dx				;\
	cmpw	%cx,%dx				;\
	jz	1f				;\
	movw	%cx,%gs				;\
1:

/* page fault */
GATE_ENTRY(0x0e,page_fault,ACC_PL_K | ACC_INTR_GATE)
	       
/* we must save %cr2 before we can be preempted -- therefore we're an
   interrupt gate (invoked with interrupts turned off), and turn them
   on here after saving %cr2 */

/* XXX slow version - sets up nice stack frame for debugger */

page_fault:
	pushl	%eax		/* save registers modifyable by C functions */
	movl    %cr2,%eax	/* save page fault address in %ecx */
	sti			/* re-enable interrupts */
	pushl	%ecx
	pushl	%edx
	RESET_KERNEL_SEGMENTS	/* scratches cx, dx */
	movl    12(%esp),%edx	/* save error code in %edx ... */
	movl	%ebp,12(%esp)	/* save frame pointer */
	leal    12(%esp),%ebp	/* load new frame pointer */
	cld
     	pushl	%edx		/* push the error code as 2nd argument */
	pushl	%eax		/* push page fault address as 1st argument */
	call	EXT(thread_page_fault)
	orl	%eax,%eax
	jz	bad_page_fault
	addl	$8,%esp
	RESET_USER_SEGMENTS
	popl	%edx
	popl	%ecx
	popl	%eax
	popl	%ebp
	iret

/* recover from a bad page fault by invoking the slow_trap handler */
bad_page_fault:
	popl	%edx		/* page fault address */
	popl	%ecx		/* restore error code */
	movl	(%ebp),%eax	/* old %ebp */
	movl	%ecx,(%ebp)
	movl	%eax,%ebp

	/* we have on stack: error code, eax, ecx, edx
	   move registers down to make room for trap number */
	subl	$4,%esp
	movl	4(%esp),%eax
	movl	%eax,(%esp)
	movl	8(%esp),%eax
	movl	%eax,4(%esp)
	movl	12(%esp),%eax
	movl	%eax,8(%esp)

	/* push error code */
	movl	$0x0e,12(%esp)

	/* push rest of struct trap_state */
	pushl	%ebx
	pushl	%edx		/* the page fault address */
	pushl	%ebp
	pushl	%esi
	pushl	%edi

	jmp	slow_2


/* timer interrupt */
GATE_ENTRY(0x28,timer_interrupt,ACC_PL_K | ACC_INTR_GATE)

timer_interrupt:
#ifndef NO_FRAME_PTR
	pushl	%ebp
	movl	%esp,%ebp
#endif
	pushl	%eax
	pushl	%edx
	pushl	%ecx
	RESET_KERNEL_SEGMENTS	/* scratches cx,dx */
	call	EXT(thread_timer_interrupt) /* enter with disabled irqs */
	RESET_USER_SEGMENTS	/* scratches cx,dx */
	popl	%ecx
	popl	%edx
	popl	%eax
#ifndef NO_FRAME_PTR
	popl	%ebp
#endif
	iret

/* profiling timer interrupt entry point */
#ifdef PROFILE

ENTRY(profile_interrupt_entry)
#ifndef NO_FRAME_PTR
	pushl	%ebp
	movl	%esp,%ebp
	pushl	%eax
	movl    8(%esp),%eax	/* %eax = return address */
#else
	pushl	%eax
	movl    4(%esp),%eax	/* %eax = return address */
#endif
	pushl	%edx
	pushl	%ecx
	RESET_KERNEL_SEGMENTS	/* scratches cx,dx */
	pushl	%eax		/* pass return address as parameter */
	call	EXT(profile_interrupt) /* enter with disabled irqs */
	addl	$4,%esp
	RESET_USER_SEGMENTS	/* scratches cx,dx */
	popl	%ecx
	popl	%edx
	popl	%eax
#ifndef NO_FRAME_PTR
	popl	%ebp
#endif
	iret

#endif /* PROFILE */

/* other interrupts */

#define INTERRUPT(int,entrypoint)				\
	GATE_ENTRY(int,entry_##entrypoint,ACC_PL_K | ACC_INTR_GATE) ;\
entry_##entrypoint:			      	 		;\
	pushl	%eax						;\
	movl	$ (int - 0x20), %eax				;\
	jmp	all_irqs

all_irqs:
	pushl	%edx
	pushl	%ecx
	RESET_KERNEL_SEGMENTS	/* scratches cx,dx */
	pushl	%eax		/* pass irq number as arg */
	call	EXT(irq_interrupt) /* enter with disabled irqs */
	addl	$4,%esp
	RESET_USER_SEGMENTS	/* scratches cx,dx */
	popl	%ecx
	popl	%edx
	popl	%eax
	iret

INTERRUPT(0x20,int0)
INTERRUPT(0x21,int1)
INTERRUPT(0x22,int2)
INTERRUPT(0x23,int3)
INTERRUPT(0x24,int4)
INTERRUPT(0x25,int5)
INTERRUPT(0x26,int6)
INTERRUPT(0x27,int7)
/* 0x28 is the timer interrupt, defined above */
INTERRUPT(0x29,int9)
INTERRUPT(0x2a,inta)
INTERRUPT(0x2b,intb)
INTERRUPT(0x2c,intc)
INTERRUPT(0x2d,intd)
INTERRUPT(0x2e,inte)
INTERRUPT(0x2f,intf)


/* system calls */

#define SYSTEM_CALL(int,entrypoint)				\
	GATE_ENTRY(int,entry_##entrypoint,ACC_PL_U | ACC_TRAP_GATE) ;\
entry_##entrypoint:			      	 		;\
	pushl	%eax						;\
	movl	$ (int - 0x30), %eax				;\
	jmp	all_syscalls

all_syscalls:
	SAVE_STATE
	RESET_KERNEL_SEGMENTS	/* scratches cx,dx */
	movl	%esp,%ebx
	pushl	%ebx		/* pass pointer to regs structure as arg  */
/* andl	$(0x0ffffc00 * (THREAD_BLOCK_SIZE / 0x400)),%ebx 
   -- parser error; use simpler construct in next line */
	andl	$(0x3ffff * THREAD_BLOCK_SIZE),%ebx
	addl	$EXT(_tcbs_1),%ebx
	pushl	%ebx		/* pass "this" pointer as arg */
	leal	EXT(syscall_table),%ebx
	shll	$3,%eax
	movl	4(%ebx,%eax),%ecx
	call	*%ecx
	addl	$8, %esp
	RESET_USER_SEGMENTS	/* scratches cx,dx */
	RESTORE_STATE
	addl	$4,%esp	/* skip %eax -- already loaded with ret value */
	iret
	
SYSTEM_CALL(0x30,sys_ipc)
SYSTEM_CALL(0x31,sys_id_nearest)
SYSTEM_CALL(0x32,sys_fpage_unmap)
SYSTEM_CALL(0x33,sys_thread_switch)
SYSTEM_CALL(0x34,sys_thread_schedule)
SYSTEM_CALL(0x35,sys_thread_ex_regs)
SYSTEM_CALL(0x36,sys_task_new)

GATE_INITTAB_END
