// -*- c++ -*-

#ifndef GLOBALS_H
#define GLOBALS_H

#include <stdlib.h>
#include <flux/machine/types.h>
#include <flux/machine/multiboot.h>
#include <flux/machine/cpuid.h>

#include "config.h"

// forward decls
class thread_t;
class space_t;

#ifdef DEFINE_GLOBALS
# define __EXTERN
#else
# define __EXTERN extern
#endif

__EXTERN multiboot_info boot_info;
__EXTERN cpu_info cpu;
__EXTERN thread_t *sigma0_thread, *kernel_thread, *nil_thread;
__EXTERN space_t *sigma0;

#undef __EXTERN

// helpers

inline thread_t *current()
{
  unsigned long t;
  __asm__ __volatile__ 
    ("movl %%esp, %0" : "=q" (t));

  return reinterpret_cast<thread_t *>(t & ~config::thread_block_mask);
}

/* the check macro is like assert(), but also evaluates its argument
   if NDEBUG is defined */
#ifdef NDEBUG
# define check(expression) ((void)(expression))
#else /* ! NDEBUG */
# define check(expression) \
         ((void)((expression) ? 0 : \
                (panic(__FILE__":%u: failed check `"#expression"'", \
                        __LINE__), 0)))
#endif /* ! NDEBUG */

#endif
