#include <flux/machine/pc/pic.h>

#include "config.h"
#include "irq.h"

//
// this version of pic_init() overrides the OSKIT's.
//
// differences to standard AT initialization: 
// . we use the "special fully nested mode" to let irq sources on the
//   slave irq raise nested
// . we give irq 2 (= slave pic) the highest prio on the master pic; this
//   results in the following sequence of prios: 8-15,3-7,0,1
//   this way, the timer interrupt on irq 8 always gets thru (even if 
//   some user irq handler doesn't acknowledge its irq!)
//
void
irq_t::init(unsigned char master_base, unsigned char slave_base)
{
#if 1
  /* Initialize the master. */
  outb_p(MASTER_ICW, PICM_ICW1);
  outb_p(MASTER_OCW, master_base);
  outb_p(MASTER_OCW, PICM_ICW3);
  outb_p(MASTER_OCW, SNF_MODE_ENA | I8086_EMM_MOD);

  /* Initialize the slave. */
  outb_p(SLAVES_ICW, PICS_ICW1);
  outb_p(SLAVES_OCW, slave_base);
  outb_p(SLAVES_OCW, PICS_ICW3);
  outb_p(SLAVES_OCW, SNF_MODE_ENA | I8086_EMM_MOD);

  // set initial masks
  outb_p(MASTER_OCW, 0xfb);	// unmask irq2
  outb_p(SLAVES_OCW, 0xff);	// mask everything

  // the timer interrupt should have the highest priority so that it
  // always gets thru 
  if (! config::profiling)
    {
      // irq 2 = irqs 8..15 have hghst prio
      outb_p(MASTER_ICW, SET_PRIORITY | 1);
      // irq 0 + 8 has highest prio on slave 
      outb_p(SLAVES_ICW, SET_PRIORITY | 7);
    }

  /* Ack any bogus intrs by setting the End Of Interrupt bit. */
  outb_p(MASTER_ICW, NON_SPEC_EOI);
  outb_p(SLAVES_ICW, NON_SPEC_EOI);

#else
  pic_init(master_base, slave_base);
#endif
}
