#include <flux/gdb.h>
#include <flux/gdb_serial.h>
#include <flux/tty.h>
#include <flux/machine/base_trap.h>
#include <flux/machine/pc/pic.h>
#include <flux/machine/pc/com_cons.h>

#include <string.h>

#include "kmem.h"
#include "config.h"

#include "kdb.h"

bool kdb::_connected = false;
int kdb::com_port = config::serial_com_port;
termios *kdb::com_params = config::serial_termios;

extern "C" void gdb_pc_com_intr();
extern unsigned gdb_pc_com_irq;

void kdb::init()
{
  // initialize GDB-via-serial

  // code copied from oskit/libkern/x86/pc/gdb_pc_com.c

  int com_irq = com_port & 1 ? 4 : 3;

  /* Tell the generic serial GDB code
     how to send and receive characters.  */
  gdb_serial_recv = com_cons_getchar;
  gdb_serial_send = com_cons_putchar;
  
  /* Tell the GDB proxy trap handler to use the serial stub.  */
  gdb_signal = gdb_serial_signal;
  
  /* Hook in the GDB proxy trap handler as the main trap handler.  */
  base_trap_handler = gdb_trap;

  /*
   * Initialize the serial port.
   * If no com_params were specified by the caller,
   * then default to base_raw_termios.
   * (If we just passed through the NULL,
   * then com_cons_init would default to base_cooked_termios,
   * which messes up the GDB remote debugging protocol.)
   */
  if (com_params == 0)
    com_params = &base_raw_termios;

  _connected = true;
  com_port_init();

  /* Hook the COM port's hardware interrupt.
     The com_cons itself uses only polling for communication;
     the interrupt is only used to allow the remote debugger
     to stop us at any point, e.g. when the user presses CTRL-C.  */
  // fill_irq_gate(com_irq, (unsigned)gdb_pc_com_intr, KERNEL_CS, ACC_PL_K);
   if (! strstr(kmem::cmdline(), " -I-") 
      && !strstr(kmem::cmdline(), " irqcom"))
     {
       fill_gate(kmem::idt + 0x20 + com_irq,
		 (unsigned)gdb_pc_com_intr,
		 kmem::gdt_code_kernel, ACC_INTR_GATE | ACC_PL_K, 0);
       gdb_pc_com_irq = com_irq;
       
       /* Enable the COM port interrupt.  */
       com_cons_enable_receive_interrupt();
       
       pic_enable_irq(com_irq);
     }
}

void 
kdb::com_port_init()
{
  if (_connected)
    com_cons_init(com_port, com_params);
}

unsigned char 
kdb::in(unsigned port)
{
  return inb_p(port);
}

void
kdb::out(unsigned port, unsigned char val)
{
  outb_p(port, val);
}
