// -*- c++ -*-

#ifndef KDB_H
#define KDB_H

#include <stdio.h>
#include <flux/gdb.h>

struct termios;

class kdb
{
public:
  static void init();
  static void com_port_init();
  static void disconnect();

  static void ke(const char *msg);

  static bool connected();

private:
  kdb();			// default constructors are undefined
  kdb(const kdb&);

  static bool _connected;
  static int com_port;
  static termios *com_params;
  
  // the following routines are for use with the kernel GDB, ala
  // call kdb::inb(port)

  static unsigned char in(unsigned port);
  static void out(unsigned port, unsigned char val);

  friend class _foo;		// avoids warning "no public cons/no friends"
};

//
// inline implementations
//

inline void kdb::ke(const char *msg)
{
  printf("KDB: %s\n", msg); gdb_breakpoint();
}

inline bool kdb::connected()
{
  return _connected;
}

inline void kdb::disconnect()
{
  // XXX should tell the remote GDB that we disconnect; for now, we
  // just unset the connected flag so that stdio will no longer do
  // output via the remote gdb

  _connected = false;
}

#endif
