/* -*- c -*- */

/* this file defines the construction of the kernel's virtual address
   space */

_tcbs_1     = 0xc0000000;	/* assumption: 256MB-aligned */
_mappings_1 = 0xe0000000;
_unused1_1  = 0xea000000;	/* assumption: 4MB-aligned */
_unused2_1  = 0xeb000000;	/* assumption: 4MB-aligned */
_unused3_1  = 0xed000000;	/* assumption: 4MB-aligned */
_kstatic1_1 = 0xee000000;	/* assumption: 4MB-aligned */
_iobitmap_1 = 0xef000000;	/* assumption: 4MB-aligned */
_physmem_1  = 0xf0000000;	/* assumption: 256MB-aligned */

load_address = 0x1000;

ENTRY(_start)

SECTIONS {
  . = _physmem_1 + load_address;

  .text : {
    *(.init .text .fini .rodata .data .anno .ctors .dtors)
    CONSTRUCTORS

    . = ALIGN(0x1000);

    _edata  =  .;
    *(.bss COMMON)
  }

  _end = . ;
}
