// adapted freely from gcc's gmon.c

/*-
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if 0
#ifndef lint
static char sccsid[] = "@(#)gmon.c	5.3 (Berkeley) 5/22/91";
#endif /* not lint */
#endif

#if 0				// L4 kernel

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#else

// L4 kernel definitions

# include <flux/machine/asm.h>

# include <stdio.h>
# include <assert.h>

# include "../config.h"
# include "../kdb.h"
# include "../kmem.h"
# include "../thread.h"		// for stack overrun checking

# define creat(fname, mode)						\
  ({ printf("starting to output: " fname ".uu -- hit Return\n");	\
     kdb::disconnect();							\
     config::use_serial = false;					\
     getchar();								\
     config::use_serial = true;						\
     uu_open(fname, mode);						\
     6; })

# define perror(foo) do {} while(0)

# define write(fd, buf, size)			\
  if (fd == 6)					\
    uu_write(buf, size);			\
  else if (fd == 2)				\
    kdb::ke(buf);				\
  else						\
    panic("assertion failed in gmon.c:write()")

# define close(fd)				\
  assert(fd == 6);				\
  uu_close();					\
  config::use_serial = false;

#endif

#ifdef DEBUG
#include <stdio.h>
#endif

#include "gmon.h"

#if 0				// L4 kernel

/* extern asm ("mcount"); */
/* extern */ char *minbrk; /* asm ("_minbrk"); */

#else
# define sbrk(x) (kmem::alloc(x))
#endif

#if 0				// L4 kernel

#ifdef __STDC__
void moncontrol  ( int );
void monstartup  ( char *, char * );
void _mcleanup   ( void );
void mcount      ( void );
#else
void moncontrol  ();
void monstartup  ();
void _mcleanup   ();
void mcount      ();
#endif

#else  // ! 0
# include "../lib.h"
#endif

/*
 *	froms is actually a bunch of unsigned shorts indexing tos
 */
static int		profiling = 3;
static unsigned short	*froms;
static struct tostruct	*tos = 0;
static long		tolimit = 0;
static char		*s_lowpc = 0;
static char		*s_highpc = 0;
static unsigned long	s_textsize = 0;

static int	ssiz;
static char	*sbuf;
static int	s_scale;
    /* see profil(2) where this is describe (incorrectly) */
#define		SCALE_1_TO_1	0x10000L

//
// emulation of the profil() system call
//

char *pr_base;
vm_offset_t pr_off;
vm_size_t pr_size;
vm_size_t pr_scale;

static inline int
profil(char *samples, vm_size_t size, vm_offset_t offset, vm_size_t scale)
{
  pr_base = samples;
  pr_size = size;
  pr_off = offset;
  pr_scale = scale;

  return 0;
}

/*
 * Control profiling
 *	profiling is what mcount checks to see if
 *	all the data structures are ready.
 */
extern "C" void
moncontrol( int mode )
{
    int ret;
#if 0				// L4 kernel
    static int warned = 0;
#endif

    if (mode) {
	/* start */
	ret = profil(sbuf + sizeof(struct phdr), ssiz - sizeof(struct phdr),
		(vm_offset_t)s_lowpc, s_scale);
#if 0				// L4 kernel
	if (ret < 0 && errno == ENOSYS && !warned) {
#   define	PROFIL_WARN	"warning: kernel does not support profiling\n"
		write(2, PROFIL_WARN, sizeof(PROFIL_WARN));
		warned = 1;
	}
#endif
	profiling = 0;
    } else {
	/* stop */
	profil((char *)0, 0, 0, 0);
	profiling = 3;
    }
}

#define	MSG "No space for profiling buffer(s)\n"

extern "C" void
monstartup( char *lowpc, char *highpc )
{
    int			monsize;
    char		*buffer;
    register int	o;

	/*
	 *	round lowpc and highpc to multiples of the density we're using
	 *	so the rest of the scaling (here and in gprof) stays in ints.
	 */
    lowpc = (char *)
	    ROUNDDOWN((unsigned)lowpc, HISTFRACTION*sizeof(HISTCOUNTER));
    s_lowpc = lowpc;
    highpc = (char *)
	    ROUNDUP((unsigned)highpc, HISTFRACTION*sizeof(HISTCOUNTER));
    s_highpc = highpc;
    s_textsize = highpc - lowpc;
    monsize = (s_textsize / HISTFRACTION) + sizeof(struct phdr);
    buffer = (char *) sbrk( monsize );
    if ( buffer == (char *) -1 ) {
	write( 2 , MSG , sizeof(MSG) );
	return;
    }
    froms = (unsigned short *) sbrk( s_textsize / HASHFRACTION );
    if ( froms == (unsigned short *) -1 ) {
	write( 2 , MSG , sizeof(MSG) );
	froms = 0;
	return;
    }
    tolimit = s_textsize * ARCDENSITY / 100;
    if ( tolimit < MINARCS ) {
	tolimit = MINARCS;
    } else if ( tolimit > 65534 ) {
	tolimit = 65534;
    }
    tos = (struct tostruct *) sbrk( tolimit * sizeof( struct tostruct ) );
    if ( tos == (struct tostruct *) -1 ) {
	write( 2 , MSG , sizeof(MSG) );
	froms = 0;
	tos = 0;
	return;
    }
#if 0				// L4 kernel
    minbrk = (char *) sbrk(0);
#endif
    tos[0].link = 0;
    sbuf = buffer;
    ssiz = monsize;
    ( (struct phdr *) buffer ) -> lpc = lowpc;
    ( (struct phdr *) buffer ) -> hpc = highpc;
    ( (struct phdr *) buffer ) -> ncnt = ssiz;
#ifdef GMON_OUT_44BSD
    ( (struct phdr *) buffer ) -> version = GMONVERSION;
    ( (struct phdr *) buffer ) -> profrate = config::profiling_rate;
#endif // GMON_OUT_44BSD
    monsize -= sizeof(struct phdr);
    if ( monsize <= 0 )
	return;
    o = highpc - lowpc;
    if( monsize < o )
#ifndef hp300
	s_scale = ( (float) monsize / o ) * SCALE_1_TO_1;
#else /* avoid floating point */
    {
	int quot = o / monsize;

	if (quot >= 0x10000)
		s_scale = 1;
	else if (quot >= 0x100)
		s_scale = 0x10000 / quot;
	else if (o >= 0x800000)
		s_scale = 0x1000000 / (o / (monsize >> 8));
	else
		s_scale = 0x1000000 / ((o << 8) / monsize);
    }
#endif
    else
	s_scale = SCALE_1_TO_1;
    moncontrol(1);
}

extern "C" void
_mcleanup( void )
{
    int			fd;
    int			fromindex;
    int			endfrom;
    char		*frompc;
    int			toindex;
    struct rawarc	rawarc;

    moncontrol(0);
    fd = creat( "gmon.out" , 0666 );
    if ( fd < 0 ) {
	perror( "mcount: gmon.out" );
	return;
    }
#   ifdef DEBUG
	fprintf( stderr , "[mcleanup] sbuf 0x%x ssiz %d\n" , sbuf , ssiz );
#   endif DEBUG
    write( fd , sbuf , ssiz );
    endfrom = s_textsize / (HASHFRACTION * sizeof(*froms));
    for ( fromindex = 0 ; fromindex < endfrom ; fromindex++ ) {
	if ( froms[fromindex] == 0 ) {
	    continue;
	}
	frompc = s_lowpc + (fromindex * HASHFRACTION * sizeof(*froms));
	for (toindex=froms[fromindex]; toindex!=0; toindex=tos[toindex].link) {
#	    ifdef DEBUG
		fprintf( stderr ,
			"[mcleanup] frompc 0x%x selfpc 0x%x count %d\n" ,
			frompc , tos[toindex].selfpc , tos[toindex].count );
#	    endif DEBUG
	    rawarc.raw_frompc = (unsigned long) frompc;
	    rawarc.raw_selfpc = (unsigned long) tos[toindex].selfpc;
	    rawarc.raw_count = tos[toindex].count;
	    write( fd , (char *) &rawarc , sizeof rawarc );
	}
    }
    close( fd );
}

extern "C" void
__mcount_internal(unsigned short *frompcindex, char *selfpc )
{
	register struct tostruct	*top;
	register struct tostruct	*prevtop;
	register long			toindex;

#if 0
	register char			*selfpc;
	register unsigned short		*frompcindex;
	/*
	 *	find the return address for mcount,
	 *	and the return address for mcount's caller.
	 */

	/* selfpc = pc pushed by mcount call.
	   This identifies the function that was just entered.  */
	selfpc = (char *) __builtin_return_address (0);
	/* frompcindex = pc in preceding frame.
	   This identifies the caller of the function just entered.  */
	frompcindex = (unsigned short *) __builtin_return_address (1);
#endif

	// kludge: check here for stack overruns
	static bool overrun = false;
	if (! overrun)
	  {
	    vm_offset_t sp;
	    asm("movl %%esp, %0" : "=r" (sp));
	    if ((sp & 0xf8000000) == kmem::mem_tcbs
		&& ((vm_offset_t)current()) + sizeof(thread_t) + 0x20 > sp)
	      {
		overrun = true;
		panic("stack overrun: current=0x%x, esp=0x%x", 
		      (vm_offset_t)current(), sp);
	      }
	  }

	/*
	 *	check that we are profiling
	 *	and that we aren't recursively invoked.
	 */
	if (profiling) {
		goto out;
	}
	profiling++;
	/*
	 *	check that frompcindex is a reasonable pc value.
	 *	for example:	signal catchers get called from the stack,
	 *			not from text space.  too bad.
	 */
	frompcindex = (unsigned short *)((long)frompcindex - (long)s_lowpc);
	if ((unsigned long)frompcindex > s_textsize) {
		goto done;
	}
	frompcindex =
	    &froms[((long)frompcindex) / (HASHFRACTION * sizeof(*froms))];
	toindex = *frompcindex;
	if (toindex == 0) {
		/*
		 *	first time traversing this arc
		 */
		toindex = ++tos[0].link;
		if (toindex >= tolimit) {
			goto overflow;
		}
		*frompcindex = toindex;
		top = &tos[toindex];
		top->selfpc = selfpc;
		top->count = 1;
		top->link = 0;
		goto done;
	}
	top = &tos[toindex];
	if (top->selfpc == selfpc) {
		/*
		 *	arc at front of chain; usual case.
		 */
		top->count++;
		goto done;
	}
	/*
	 *	have to go looking down chain for it.
	 *	top points to what we are looking at,
	 *	prevtop points to previous top.
	 *	we know it is not at the head of the chain.
	 */
	for (; /* goto done */; ) {
		if (top->link == 0) {
			/*
			 *	top is end of the chain and none of the chain
			 *	had top->selfpc == selfpc.
			 *	so we allocate a new tostruct
			 *	and link it to the head of the chain.
			 */
			toindex = ++tos[0].link;
			if (toindex >= tolimit) {
				goto overflow;
			}
			top = &tos[toindex];
			top->selfpc = selfpc;
			top->count = 1;
			top->link = *frompcindex;
			*frompcindex = toindex;
			goto done;
		}
		/*
		 *	otherwise, check the next arc on the chain.
		 */
		prevtop = top;
		top = &tos[top->link];
		if (top->selfpc == selfpc) {
			/*
			 *	there it is.
			 *	increment its count
			 *	move it to the head of the chain.
			 */
			top->count++;
			toindex = prevtop->link;
			prevtop->link = top->link;
			top->link = *frompcindex;
			*frompcindex = toindex;
			goto done;
		}

	}
done:
	profiling--;
	/* and fall through */
out:
	return;		/* normal return restores saved registers */

overflow:
	profiling++; /* halt further profiling */
#   define	TOLIMIT	"mcount: tos overflow\n"
	write(2, TOLIMIT, sizeof(TOLIMIT));
	goto out;
}

/* The GNU Glibc has this to say:

   We need a special version of the `mcount' function since for ix86 it
   must not clobber any register.  This has several reasons:
     - there is a bug in gcc as of version 2.7.2.2 which prohibits the
       use of profiling together with nested functions
     - the ELF `fixup' function uses GCC's regparm feature
     - some (future) systems might want to pass parameters in registers.  */

#define __STR(x) #x
#define STR(x) __STR(x)

asm(
STR(Entry(mcount)) 
    "pushl %eax
     pushl %ecx
     pushl %edx

     movl 12(%esp), %eax
     movl 4(%ebp), %ecx
     pushl %eax
     pushl %ecx

     call " STR(EXT(__mcount_internal)) "
     addl $8,%esp

     popl %edx
     popl %ecx
     popl %eax
     ret");
