// -*- c++ -*-

#ifndef LIST_H
#define LIST_H

#include "atomic.h"

//
// single list types
//

template <class T>
class list_stack_t
{
public:
  void insert(T* e);
  T* dequeue();
  T* first();
  void reset();
private:
  T* my_first;
};

template <class T>
class list_simple_t 
{
public:
  void insert(T* e);
  void append(T* e);
  T* dequeue();
  void reset();
private:
  T* my_first;
  T* my_last;
};

// elem type -- to be used in elements which must be singly-listed,
// with name "list_property"
template <class T>
class sllist_elem_t
{
private:
  T *next;

  friend class list_stack_t<T>;
  friend class list_simple_t<T>;
};


//
// inline stuff
//

// list_stack_t<T>

template <class T>
inline void list_stack_t<T>::insert(T *e)
{
  do 
    {
      e->list_property.next = my_first;
    }
  while (! compare_and_swap(&my_first, e->list_property.next, e));
}

template <class T>
inline T* list_stack_t<T>::dequeue()
{
  T* e;

  do 
    {
      e = my_first;
    }
  while (e && ! compare_and_swap(&my_first, e, e->list_property.next));

  return e;
}

template <class T>
inline T* list_stack_t<T>::first()
{
  return my_first;
}

template <class T>
inline void list_stack_t<T>::reset()
{
  my_first = 0;
}

#endif
