// this code is run just before main.  we must set up the kernel
// address space here before starting main() so that any constructors
// for static objects can be run from the main() startup code.

#include <assert.h>
#include <string.h>

#include <flux/machine/cpuid.h>

#include "kmem.h"
#include "config.h"
#include "globals.h"
#include "main.h"

extern "C" void __main(void);	// in crt0.S

extern "C" void startup(vm_offset_t mbi_pa, unsigned int flag)
{
  assert(flag == MULTIBOOT_VALID); /* we need to be multiboot-booted */

  // Dependent on how we've been booted, the BSS might not have been
  // cleaned out.  Do this now.  This is safe because we made sure in
  // crt0.S that our stack is not in the BSS.
  memset(&_edata, 0, &_end - &_edata);

  // cpu info; need to do this before setting up page tables because
  // we need to know whether we can use 4MB pages.
  cpuid(&cpu);

  // the first thing to set up is the page-level allocator so that we
  // can allocate page tables from it
  kmem::init(mbi_pa);

  // initializate some globals here; in particular, we must copy
  // config data still located in user memory into kernel space

  // make a copy of the Multiboot info structure before it gets overwritten
  boot_info = 
    * static_cast<multiboot_info*>(kmem::phys_to_virt(mbi_pa));
  
  // initialize config data before running constructors
  config::init();

  // initialize static objects
  __main();

  // now run the main program
  exit(main());
}
