// -*- c++ -*-

#ifndef THREAD_LIST_H
#define THREAD_LIST_H

// queue operations

// XXX for now, synchronize via cli/sti pairs
inline bool 
thread_t::in_ready_list()
{
  return ready_next;
}

inline void
thread_t::ready_enqueue()
{
  unsigned flags = get_eflags();
  cli();
  if (! in_ready_list())
    {
      if (! prio_first[my_prio])
	prio_first[my_prio] = this;
      if (! prio_next[my_prio])
	prio_next[my_prio] = this;

      if (my_prio > prio_highest)
	prio_highest = my_prio;

      // enqueue as the last tcb of this prio, i.e., just before the
      // first tcb of the next prio
      thread_t *sibling;
      unsigned i = my_prio;

      do 
	{
	  if (++i == 256) i = 0;
	  sibling = prio_first[i];
	}
      while (! sibling);	// loop terminates at least at kernel_thread

      ready_next = sibling;
      ready_prev = sibling->ready_prev;
      sibling->ready_prev = this;
      ready_prev->ready_next = this;
    }
  set_eflags(flags);
}

inline void
thread_t::ready_dequeue()
{
  unsigned flags = get_eflags();
  cli();
  if (in_ready_list())
    {
      if (prio_first[my_prio] == this)
	prio_first[my_prio] = ready_next->my_prio == my_prio ? ready_next : 0;
      if (prio_next[my_prio] == this)
	prio_next[my_prio] = ready_next->my_prio == my_prio ?
	  ready_next : prio_first[my_prio];

      if (prio_first[my_prio] == 0 && my_prio == prio_highest)
	prio_highest = ready_prev->my_prio;
      
      ready_prev->ready_next = ready_next;
      ready_next->ready_prev = ready_prev;
      ready_next /* = ready_prev */  = 0;

    }
  set_eflags(flags);
}

inline bool 
thread_t::in_present_list()
{
  return present_next;
}

inline void
thread_t::present_enqueue(thread_t *sibling)
{
  unsigned flags = get_eflags();
  cli();
  if (! in_present_list())
    {
      present_next = sibling->present_next;
      present_prev = sibling;
      sibling->present_next = this;
      present_next->present_prev = this;
    }
  set_eflags(flags);
}

inline void
thread_t::present_dequeue()
{
  unsigned flags = get_eflags();
  cli();
  if (in_present_list())
    {
      present_prev->present_next = present_next;
      present_next->present_prev = present_prev;
      present_next /* = present_prev */ = 0;
    }
  set_eflags(flags);
}

#if 0
inline sender_t *
thread_t::sender_dequeue_first()
{
  unsigned flags = get_eflags();
  cli();
  
  sender_t *r = sender_first;

  if (r)
    {
      if (r->sender_next != r)
	{
	  r->sender_next->sender_prev = r->sender_prev;
	  r->sender_prev->sender_next = r->sender_next;
	}

      r->sender_next = 0;
    }
  set_eflags(flags);

  return r;
}
#endif

inline bool 
sender_t::in_sender_list()
{
  return sender_next;
}

inline void
sender_t::sender_enqueue(thread_t *r)
{
  unsigned flags = get_eflags();
  cli();
  if (! in_sender_list())
    {
      if (r->sender_first)
	{
	  sender_next = r->sender_first;
	  sender_prev = sender_next->sender_prev;
	  sender_prev->sender_next = this;
	  sender_next->sender_prev = this;
	}
      else
	{
	  r->sender_first = sender_prev = sender_next = this;
	}
    }
  set_eflags(flags);
}

inline void
sender_t::sender_dequeue(thread_t *r)
{
  unsigned flags = get_eflags();
  cli();
  if (in_sender_list())
    {
      if (sender_next == this)	// are we alone in the list?
	{
	  assert(r->sender_first == this);

	  r->sender_first = 0;
	}
      else
	{
	  if (r->sender_first == this) // are we first in the list?
	    r->sender_first = sender_next;

	  sender_prev->sender_next = sender_next;
	  sender_next->sender_prev = sender_prev;
	}

      sender_next = 0;
    }
  set_eflags(flags);
}

#endif
