/*
 *  $Id: log.c,v 1.1.1.1 1999/04/06 19:20:06 yoonho Exp $
 *
 * Author:
 *	Rene Stange, <Rene.Stange@inf.tu-dresden.de>
 */

/*
 * Hercules debug screen
 */
#define BYTES_PER_CHAR		2
#define LINE			80
#define LINE24			(LINE*24)
#define LINE25			(LINE*25)

#define HERC_MEM		(*(char (*)[][BYTES_PER_CHAR])0xb0000)

static inline void scroll(void*, void*, int); 
void log(const char*);

/*
 * scrolls the hercules screen (src-dest) lines up
 */

static inline void scroll(void *dest, void *src, int n)
{
__asm__ __volatile__(
        "cld\n\t"
        "rep\n\t"
        "movsb"
        : /* no output */
        :"c" (n),"S" (src),"D" (dest)
        :"cx","si","di");
}

/*
 * prints the string on the actual position on hercules screen
 */

void log(const char *str)
{
    static unsigned cursor = 0;
    unsigned n;
    char c;

    while((c = *str++))
    {
        if(c == '\n')
	{
	    cursor += LINE;
	    cursor -= cursor % LINE;
	}
	else
	    HERC_MEM[cursor++][0] = c;

	if(cursor >= LINE25)
	{
	    cursor -= LINE;
	    scroll(HERC_MEM, HERC_MEM[LINE], LINE24*BYTES_PER_CHAR);
	    for(n = LINE24; n < LINE25; n++)
	        HERC_MEM[n][0] = ' ';
	}
    }
}














