#ifndef INIT_H
#define INIT_H

#include <l4/compiler.h>

#include "exec.h"

#define INIT_SECTION __attribute__((section (".init")))

void init(void) L4_NORETURN;

/* the following variables may only by used during boot -- their
   storage is freed after initialization in init.c */

extern int boot_errors, boot_wait;

#define MODS_MAX 20
extern struct multiboot_module mb_mod[MODS_MAX];

extern vm_offset_t mod_range_start, mod_range_end;

void mod_exec_init(struct multiboot_module *mod, 
		   unsigned mod_first, unsigned mod_count);

exec_read_func_t mod_exec_read;
exec_read_exec_func_t mod_exec_read_exec;


#endif
