#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING (yyerrflag!=0)
#define YYPREFIX "yy"
#line 4 "cfg-parse.y"
#include <unistd.h>

#include "quota.h"
#include "init.h"
#include "cfg.h"

#define yyparse __cfg_parse

static void yyerror(const char *s);

unsigned __cfg_task;
static unsigned ctask;
static int assert_mod = -1;

static unsigned c_max = -1, c_low = 0, c_high = -1, c_mask = 0xffffffff;

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif
#ifndef max
#define max(x,y) ((x)>(y)?(x):(y))
#endif

#define minset(x, y) ((x) = min((x),(y)))
#define maxset(x, y) ((x) = max((x),(y)))

#line 32 "cfg-parse.y"
typedef union {
  char *string;
  unsigned number;
  struct {
    unsigned low, high;
  } interval;
} YYSTYPE;
#line 47 "y.tab.c"
#define TASK 257
#define MODNAME 258
#define CHILD 259
#define IRQ 260
#define MAX 261
#define IN 262
#define MASK 263
#define MEMORY 264
#define HIMEM 265
#define LOGMCP 266
#define BOOTMCP 267
#define BOOTPRIO 268
#define BOOTWAIT 269
#define RMGR 270
#define SIGMA0 271
#define DEBUGFLAG 272
#define VERBOSE 273
#define LOG 274
#define SMALLSIZE 275
#define SMALL 276
#define BOOTSMALL 277
#define MODULE 278
#define UNSIGNED 279
#define STRING 280
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    4,    4,    5,    5,    5,    9,   10,   10,   10,
   10,    8,    8,   11,    6,    6,    6,    6,   13,   12,
   12,   14,    7,    7,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   16,   19,   17,   18,   18,   20,   20,
   22,   22,    2,   21,   23,    1,    3,
};
short yylen[] = {                                         2,
    1,    2,    0,    3,    1,    1,    2,    1,    1,    1,
    3,    0,    2,    1,    2,    2,    2,    2,    1,    2,
    0,    2,    2,    0,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    1,    1,    1,    1,    1,    2,    1,
    2,    2,    5,    1,    2,    1,    1,
};
short yydefred[] = {                                      0,
    0,    8,   10,    9,    0,    0,    0,    1,    0,    0,
    5,    6,    0,   16,   17,   46,   18,    0,    7,    2,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   15,    0,   11,    0,    0,   25,   34,    0,
    0,   28,   37,   38,   44,   26,   36,   27,   30,   31,
   32,   29,   35,   33,   14,    4,    0,   23,   47,   22,
   20,   41,    0,   42,   39,   45,   13,    0,    0,    0,
   43,
};
short yydgoto[] = {                                       7,
   17,   64,   60,    8,    9,   10,   30,   56,   11,   12,
   57,   33,   13,   34,   31,   38,   46,   42,   52,   47,
   44,   40,   45,
};
short yysindex[] = {                                   -257,
 -265,    0,    0,    0, -270, -270,    0,    0, -257, -213,
    0,    0, -247,    0,    0,    0,    0, -270,    0,    0,
 -226, -229, -226, -226, -270, -270, -270, -226, -270, -259,
 -213, -267,    0, -247,    0, -270,  -70,    0,    0, -226,
 -270,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -247,    0,    0,    0,
    0,    0, -270,    0,    0,    0,    0,  -20, -270,  -67,
    0,
};
short yyrindex[] = {                                     30,
    1,    0,    0,    0,    0,    0,    0,    0,   30,   58,
    0,    0,   23,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   68,
   58,    0,    0,   23,    0,    0,    0,    0,    0,   45,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   77,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
short yygindex[] = {                                      0,
    2,    0,    0,   28,    0,    0,    8,    0,    0,    0,
    0,  -32,    0,    0,    0,    0,   16,    0,    0,  -18,
    0,    0,    0,
};
#define YYTABLESIZE 352
short yytable[] = {                                       1,
   19,   61,   39,   43,   14,   15,   18,   19,   16,   53,
   32,    2,   59,   16,    3,    4,    5,    6,   55,   35,
   63,   65,   21,   69,   67,   71,   49,   50,   51,    3,
   54,   36,   37,   41,   36,   37,   20,   62,   58,   48,
    0,    0,   66,    0,   40,   21,   22,    0,    0,    0,
   23,   24,   25,   26,   27,    0,    0,   24,    0,    0,
    0,    0,   28,   29,   68,    0,    0,   12,    0,    0,
   70,    0,    0,    0,    0,    0,   21,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   19,   19,   19,
   19,    0,    0,    0,   19,   19,   19,   19,   19,   19,
    0,    0,   19,   19,   19,   19,   19,   19,   19,   21,
    0,   21,   21,    0,    0,    0,   21,   21,   21,   21,
   21,   21,    0,    0,   21,   21,   21,   21,   21,   21,
   21,   40,    0,   40,   40,    0,    0,    0,   40,   40,
   40,   40,   40,   40,   24,    0,   40,   40,   40,   40,
   40,   40,   40,    0,   12,    0,   24,    0,    0,   24,
   24,   24,   24,   21,    0,   24,   12,    0,    0,   12,
   12,   12,   12,    0,    0,   21,    0,    0,   21,   21,
   21,   21,
};
short yycheck[] = {                                     257,
    0,   34,   21,   22,  270,  271,    5,    6,  279,   28,
  258,  269,  280,  279,  272,  273,  274,  275,  278,   18,
   91,   40,    0,   44,   57,   93,   25,   26,   27,    0,
   29,  261,  262,  263,  261,  262,    9,   36,   31,   24,
   -1,   -1,   41,   -1,    0,  259,  260,   -1,   -1,   -1,
  264,  265,  266,  267,  268,   -1,   -1,    0,   -1,   -1,
   -1,   -1,  276,  277,   63,   -1,   -1,    0,   -1,   -1,
   69,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,
  260,   -1,   -1,   -1,  264,  265,  266,  267,  268,  269,
   -1,   -1,  272,  273,  274,  275,  276,  277,  278,  257,
   -1,  259,  260,   -1,   -1,   -1,  264,  265,  266,  267,
  268,  269,   -1,   -1,  272,  273,  274,  275,  276,  277,
  278,  257,   -1,  259,  260,   -1,   -1,   -1,  264,  265,
  266,  267,  268,  269,  257,   -1,  272,  273,  274,  275,
  276,  277,  278,   -1,  257,   -1,  269,   -1,   -1,  272,
  273,  274,  275,  257,   -1,  278,  269,   -1,   -1,  272,
  273,  274,  275,   -1,   -1,  269,   -1,   -1,  272,  273,
  274,  275,
};
#define YYFINAL 7
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 280
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'['",0,"']'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"TASK","MODNAME",
"CHILD","IRQ","MAX","IN","MASK","MEMORY","HIMEM","LOGMCP","BOOTMCP","BOOTPRIO",
"BOOTWAIT","RMGR","SIGMA0","DEBUGFLAG","VERBOSE","LOG","SMALLSIZE","SMALL",
"BOOTSMALL","MODULE","UNSIGNED","STRING",
};
char *yyrule[] = {
"$accept : file",
"file : rules",
"rules : rule rules",
"rules :",
"rule : taskspec constraints modules",
"rule : smallsizerule",
"rule : flag",
"smallsizerule : SMALLSIZE number",
"flag : BOOTWAIT",
"flag : VERBOSE",
"flag : DEBUGFLAG",
"flag : LOG number number",
"modules :",
"modules : nextmod asserts",
"nextmod : MODULE",
"taskspec : nexttask asserts",
"taskspec : TASK RMGR",
"taskspec : TASK SIGMA0",
"taskspec : TASK number",
"nexttask : TASK",
"asserts : assert asserts",
"asserts :",
"assert : MODNAME string",
"constraints : constraint constraints",
"constraints :",
"constraint : CHILD childconstraints",
"constraint : MEMORY memoryconstraints",
"constraint : HIMEM memoryconstraints",
"constraint : IRQ irqconstraints",
"constraint : SMALL smallconstraints",
"constraint : LOGMCP number",
"constraint : BOOTMCP number",
"constraint : BOOTPRIO number",
"constraint : BOOTSMALL number",
"childconstraints : numconstraints",
"smallconstraints : numconstraints",
"memoryconstraints : numconstraints",
"irqconstraints : numconstraints",
"irqconstraints : maskconstraints",
"numconstraints : numconstraint numconstraints",
"numconstraints : numconstraint",
"numconstraint : MAX number",
"numconstraint : IN setspec",
"setspec : '[' number ',' number ']'",
"maskconstraints : maskconstraint",
"maskconstraint : MASK number",
"number : UNSIGNED",
"string : STRING",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 223 "cfg-parse.y"
/* end of grammer -- misc C source code follows */

#include "cfg-scan.c"

static void yyerror(const char *s)
{
  printf("RMGR: ERROR: while parsing config file: %s\n"
	 "             at line %d, col %d\n", s, line, col);
}


#ifdef TEST

char cfg[] = "task modname 'foo'\n"
             "#a comment\n"
             "child in [10,30] max 100\n";

int main(void)
{
  cfg_setup_input(cfg, cfg + sizeof(cfg));

  return cfg_parse();
}

#endif /* TEST */
#line 321 "y.tab.c"
#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 4:
#line 58 "cfg-parse.y"
{ quota_t *q = & quota[ctask];
					  bootquota_t *b = 
					    & bootquota[ctask];
					  printf("RMGR: configured "
						 "task 0x%x: "
						 "[ m:%x,%x,%x "
						 "hm:%x,%x,%x\n      "
						 "t:%x,%x,%x "
						 "i:%x lmcp:%x "
						 "s:%x,%x,%x\n      "
						 "mcp:%x prio:%x "
						 "small:%x ]\n", 
						 ctask,
						 q->mem.low, q->mem.high,
						 q->mem.max, q->himem.low, 
						 q->himem.high, q->himem.max, 
						 q->task.low,
						 q->task.high, q->task.max,
						 q->irq.max, q->log_mcp,
						 q->small.low, q->small.high,
						 q->small.max,
						 b->mcp, b->prio, 
						 b->small_space);
					  assert_mod = -1; }
break;
case 7:
#line 86 "cfg-parse.y"
{ small_space_size = yyvsp[0].number; }
break;
case 8:
#line 88 "cfg-parse.y"
{ boot_wait++; }
break;
case 9:
#line 89 "cfg-parse.y"
{ verbose++; }
break;
case 10:
#line 90 "cfg-parse.y"
{ debug++; }
break;
case 11:
#line 91 "cfg-parse.y"
{ debug_log_mask = yyvsp[-1].number;
					  debug_log_types = yyvsp[0].number; }
break;
case 13:
#line 96 "cfg-parse.y"
{ bootquota[ctask].mods++; }
break;
case 14:
#line 99 "cfg-parse.y"
{ assert_mod++; }
break;
case 16:
#line 103 "cfg-parse.y"
{ ctask = myself.id.task; }
break;
case 17:
#line 104 "cfg-parse.y"
{ ctask = my_pager.id.task; }
break;
case 18:
#line 105 "cfg-parse.y"
{ ctask = yyvsp[0].number; }
break;
case 19:
#line 108 "cfg-parse.y"
{ ctask = __cfg_task++;
					  assert_mod = ctask - 3; }
break;
case 22:
#line 115 "cfg-parse.y"
{ char *n;
					  if (assert_mod < 1)
					    {
					      printf("RMGR: ERROR: no boot "
					             "module associated with "
						     "modname %s\n",
						     yyvsp[0].string);
					      boot_errors++;
					      goto assert_end;
					    }
					  n = (char *)
					    mb_mod[assert_mod].string;
					  if (! n)
					    {
					      printf("RMGR: WARNING: cmdlines "
						     "unsupported, can't "
						     "verify modname %s\n",
						     yyvsp[0].string);
					    }
					  else if (! strstr(n, yyvsp[0].string))
					    {
					      printf("RMGR: ERROR: modname "
						     "%s doesn't match "
						     "cmdline %s\n",
						     yyvsp[0].string, n);
					      boot_errors++;
					    }
					assert_end:
					  free(yyvsp[0].string);
					}
break;
case 25:
#line 151 "cfg-parse.y"
{ maxset(quota[ctask].task.low, c_low);
					  minset(quota[ctask].task.high, c_high);
					  minset(quota[ctask].task.max, c_max);
                                          c_low = 0; c_high = -1; c_max = -1; }
break;
case 26:
#line 155 "cfg-parse.y"
{ maxset(quota[ctask].mem.low, c_low);
					  minset(quota[ctask].mem.high, c_high);
					  minset(quota[ctask].mem.max, c_max);
                                          c_low = 0; c_high = -1; c_max = -1; }
break;
case 27:
#line 159 "cfg-parse.y"
{ maxset(quota[ctask].himem.low, c_low);
					  minset(quota[ctask].himem.high, c_high);
					  minset(quota[ctask].himem.max, c_max);
                                          c_low = 0; c_high = -1; c_max = -1; }
break;
case 28:
#line 163 "cfg-parse.y"
{ unsigned mask = 0, i;
					  for (i = max(0, c_low);
					       i <= min(15, c_max);
					       i++)
					    {
                                              mask |= 1L << i;
					    }
					  quota[ctask].irq.max &= 
					    c_mask & mask;
                                          c_low = 0; c_high = -1; c_max = -1;
					  c_mask = 0xffffffff; }
break;
case 29:
#line 174 "cfg-parse.y"
{ maxset(quota[ctask].small.low, c_low);
					  minset(quota[ctask].small.high, c_high);
					  minset(quota[ctask].small.max, c_max);
                                          c_low = 0; c_high = -1; c_max = -1; }
break;
case 30:
#line 178 "cfg-parse.y"
{ quota[ctask].log_mcp = yyvsp[0].number; }
break;
case 31:
#line 179 "cfg-parse.y"
{ bootquota[ctask].mcp = yyvsp[0].number; }
break;
case 32:
#line 180 "cfg-parse.y"
{ bootquota[ctask].prio = yyvsp[0].number; }
break;
case 33:
#line 181 "cfg-parse.y"
{ bootquota[ctask].small_space
					    = yyvsp[0].number; }
break;
case 41:
#line 202 "cfg-parse.y"
{ c_max = min(c_max, yyvsp[0].number); }
break;
case 42:
#line 203 "cfg-parse.y"
{ c_low = max(c_low, yyvsp[0].interval.low); 
					  c_high = min(c_high, yyvsp[0].interval.high); }
break;
case 43:
#line 207 "cfg-parse.y"
{ yyval.interval.low = yyvsp[-3].number; yyval.interval.high = yyvsp[-1].number; }
break;
case 45:
#line 213 "cfg-parse.y"
{ c_mask &= yyvsp[0].number; }
break;
case 46:
#line 216 "cfg-parse.y"
{ yyval.number = strtoul(yyvsp[0].string, 0, 0); }
break;
case 47:
#line 219 "cfg-parse.y"
{ yyval.string = strdup(yyvsp[0].string + 1);
					  yyval.string[strlen(yyval.string) - 1] = 0; }
break;
#line 653 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
