/* $Id: pci.c,v 1.1 1999/07/26 18:44:25 yoonho Exp $

   This file implements the function pci_reloc.
   pci_reloc is is called to reorder the memory areas of PCI devices
   in a way that every area is in a different SuperPage (4M)
   
   $Log: pci.c,v $
   Revision 1.1  1999/07/26 18:44:25  yoonho
   Added Uwe's PCI relocation code

 */

/* define DEBUG to see all relocations and wait forever after all */
#define DEBUG


#include <l4/types.h>
#if 0
#include <l4/pci/libpci.h>
#else /* 0 */
#include "libpci.h"
#endif /* 0 */


#if defined(DEBUG)
#include <stdio.h>
#define LOOPHERE() do { } while(0/* 42 */)
#else
#define printf(fmt, args...)
#define LOOPHERE() do { } while(0)
#endif



/* prototype */
void pci_reloc(void);

void
pci_reloc(void)
{
    int tmp;
    struct pci_dev *pcidev;
    unsigned int next_addr = 0xc0000000;
    
    /* After initializing the PCI machinery ... */
    pci_init();
    
    /* ... walk along the list of all PCI devices ... */
    for (pcidev = pci_devices; pcidev; pcidev = pcidev->next)
    {
	printf("dev %04X:%04X:\n", pcidev->vendor, pcidev->device);
	/* ... looking at every base_address ... */
	for (tmp = 0; tmp < 6; tmp++)
	{
	    /* ... if it is a valid entry ... */
	    if (pcidev->base_address[tmp] & ~3)
	    {
		/* ... and if so, relocate it ... */
		unsigned tmpaddr;
		
		/* ... by first figuring out the size 
		   it claims on the bus ... */
		pci_write_config_dword(pcidev,
				       0x10 + (tmp * 4),
				       0xffffffff);
		pci_read_config_dword(pcidev,
				      0x10 + (tmp * 4),
				      &tmpaddr);
		tmpaddr = (~(tmpaddr & ~3))+1;
		pci_write_config_dword(pcidev,
				       0x10 + (tmp * 4),
				       pcidev->base_address[tmp]);
		printf("  %s @ %08lX - msk: %08X",
		       (pcidev->base_address[tmp] & 1) ? "IO " : "MEM",
		       (pcidev->base_address[tmp] & ~3), tmpaddr);
		/* ... while strictly ignoring IO space ... */
		if (!(pcidev->base_address[tmp] & 1))
		{
		    next_addr = (next_addr + (tmpaddr - 1)) & ~(tmpaddr - 1);
		    pci_write_config_dword(pcidev,
					   0x10 + (tmp * 4),
					   next_addr);
		    printf(" -> 0x%08x", next_addr);
		    /* round up to next superpage */
		    next_addr += ((tmpaddr + (L4_SUPERPAGESIZE-1)) &
				  L4_SUPERPAGEMASK);
		};
		printf("\n");
	    };
	}
    };
    
    LOOPHERE();
};
