#include <flux/machine/multiboot.h>
#include <l4/compiler.h>

#include "exec.h"

/* this function is mapped into a new tasks address space to load the
   registers in a multiboot-compliant way before starting the task's
   real code */
void task_trampoline(vm_offset_t entry, struct multiboot_info *mbi)
{
  asm volatile("movl %%edx,%%ebx
                call *%%ecx
                .globl " SYMBOL_NAME_STR(_task_trampoline_end) "\n"
	        SYMBOL_NAME_STR(_task_trampoline_end) ":"
	       :		/* nothing out */
	       : "c" (entry), "d" (mbi), "a" (MULTIBOOT_VALID) /* in */
	       : "eax", "ecx", "edx"	/* scratch */
	       );

  /* NORETURN */
}
