/* This is a library for establishing a character pipe style of communication
 * with another task */
#include <l4/types.h>
#include <l4/ipc.h>
#include <services/lib/utils.h>
#include <services/lib/ipcpipe.h>

l4_threadid_t mytask = L4_NIL_ID;

static void speaker (int pport);
static void listener (int pport);

int
ipcpipe_open (ipcpipe_t *port,
              l4_threadid_t remote_listener, l4_threadid_t remote_speaker,
              int local_listener_lthread, int local_speaker_lthread,
              int local_notify_break_lthread,
              void *local_listener_stack, void *local_speaker_stack)
{
  int dum;
  l4_msgdope_t result;
  port->remote_listener = remote_listener;
  port->remote_speaker = remote_speaker;
  if (mytask.dw == L4_NIL_ID.dw)
    mytask = l4_myself();
  port->local_listener = mytask;
  port->local_listener.id.lthread = local_listener_lthread;
  port->local_speaker = mytask;
  port->local_speaker.id.lthread = local_speaker_lthread;
  port->local_notify_break = mytask;
  port->local_notify_break.id.lthread = local_notify_break_lthread;
  port->inqhead = port->inqtail = port->outqhead = port->outqtail = 0;
  init_consume_produce(&port->inqcp, mytask, port->local_listener,QUEUESIZE-1);
  init_consume_produce(&port->outqcp, port->local_speaker, mytask,QUEUESIZE-1);
  create_thread_with_param
    (local_listener_lthread, listener, local_listener_stack, L4_INVALID_ID,
     (int)port);
  create_thread_with_param
    (local_speaker_lthread, speaker, local_speaker_stack, L4_INVALID_ID,
     (int)port);
  return 0; /* TODO: fault detection at open */
}

static void
speaker (int pport)
{
  ipcpipe_t *port = (ipcpipe_t *) pport;
  int ch, ret;
  l4_msgdope_t result;
  dbgprintf ("speaker alive in task %x, port=0x%x, remote=%x.%x\n",
           mytask.id.task, port, port->remote_listener.id.task,
           port->remote_listener.id.lthread);
  l4_i386_ipc_receive (L4_NIL_ID, L4_IPC_SHORT_MSG, &ch, &ch, &ch,
                       L4_IPC_TIMEOUT(128,11,128,11,9,9), &result);
  while (3) {
    consume(&port->outqcp);
    ch = port->outqueue[port->outqhead];
    port->outqhead = (port->outqhead + 1) % QUEUESIZE;
    dbgprintf ("s%x'%c'\n", mytask.id.task, ch);
    ret = l4_i386_ipc_send (port->remote_listener, L4_IPC_SHORT_MSG,
                            ch, 0xb1be, 0, L4_IPC_NEVER, &result);
    if (ret) {
      hprintf ("ipcpipe task %x speaker ipc err 0x%x, halting thread\n",
               mytask.id.task, result);
      halt();
    }
  }
}

static void
listener (int pport)
{
  ipcpipe_t *port = (ipcpipe_t *) pport;
  int ch, dummy, ret;
  l4_msgdope_t result;
  dbgprintf ("listener alive in task %x, port=0x%x, remote=%x.%x\n",
           mytask.id.task, port, port->remote_speaker.id.task,
           port->remote_speaker.id.lthread);
  l4_i386_ipc_receive (L4_NIL_ID, L4_IPC_SHORT_MSG, &ch, &ch, &ch,
                       L4_IPC_TIMEOUT(128,11,128,11,9,9), &result);
  while (17) {
    ret = l4_i386_ipc_receive (port->remote_speaker, L4_IPC_SHORT_MSG,
                               &ch, &dummy, &dummy, L4_IPC_NEVER, &result);
    if (ret) {
      hprintf ("ipcpipe task %x listener ipc err 0x%x, halting thread\n", 
               mytask.id.task, result);
      port->inqueue[port->inqtail] = -3;
      port->inqtail = (port->inqtail + 1) % QUEUESIZE;
      halt();
    } else
      dbgprintf ("r%x'%c'\n", mytask.id.task, ch);
    if (ch == '\003') {
      l4_i386_ipc_send (port->local_notify_break, L4_IPC_SHORT_MSG,
                        -1, 0, 0, L4_IPC_NEVER, &result);
    } else {
      port->inqueue[port->inqtail] = ch;
      port->inqtail = (port->inqtail + 1) % QUEUESIZE;
      produce(&port->inqcp);
    }
  }
}


