#include <services/client/rmm.h>
#include <services/client/decodelf.h>
#include <services/client/taskserv.h>
#include <services/lib/nameservice.h>
#include <l4/types.h>
#include <l4/syscalls.h>
#include <l4/librmgr.h>
#include <services/lib/utils.h>

int
run_elf (dataspace_t exesource, int force_writeable_segs)
{
  sm_service_t elfservice, rmmservice, taskservice;
  l4_threadid_t createdtask, myid;
  dataspace_t init_ds;
  unsigned rmmstart;
  sm_exc_t exc;
  l4_strdope_t strdope;
  myid = l4_myself();
  dbgprintf ("libld: I am %x.%x\n", myid.id.task, myid.id.lthread);
  nameservice_init();
  elfservice = nameservice_get_service("decodelf");
  taskservice = nameservice_get_service("taskserv");
  rmmservice = nameservice_get_service("rmm");
  if (l4_is_invalid_id(elfservice)) { 
    return -2;
  } else if (l4_is_invalid_id(rmmservice)) {
    return -3;
  } else if (l4_is_invalid_id(taskservice))
    return -4;
  dbgprintf ("libld: decodelf=%x,taskserv=%x,rmm=%x\n", elfservice.id.task,
           taskservice.id.task, rmmservice.id.task);
  dbgprintf ("libld: calling rmm_pgr_get_rm_start()\n");
  rmm_pgr_get_rm_start (rmmservice, &rmmstart, &exc);
  if (exc._type != exc_l4_no_exception)
    return -5;
  dbgprintf ("libld: calling decodelf_dm_decode()\n");
  if (force_writeable_segs)
    decodelf_dm_decode_4debug (elfservice, &exesource, &init_ds.dsid, &exc);
  else
    decodelf_dm_decode (elfservice, &exesource, &init_ds.dsid, &exc);
  init_ds.dsm = elfservice.dw;
  if (exc._type != exc_l4_no_exception)
    return -6;
  strdope.snd_size = sizeof(init_ds);
  strdope.snd_str = (dword_t) &init_ds;
  strdope.rcv_size = 0;
  strdope.rcv_str = 0;
  dbgprintf ("libld: calling taskserv_def_create()\n");
  taskserv_def_create (taskservice, rmmservice.dw, strdope, rmmstart, 0, 6,
                       8192, &createdtask.dw, &exc);
  dbgprintf ("libld: created task %x.%x, got exc=%x\n", createdtask.id.task,
           createdtask.id.lthread, exc._type);
  if (exc._type != exc_l4_no_exception) {
    decodelf_dm_close (elfservice, init_ds.dsid, &exc);
    return -7;
  }
  decodelf_dm_transfer (elfservice, init_ds.dsid, createdtask.dw, &exc);
  if (exc._type != exc_l4_no_exception)
    return -8;
  /* rmm_pgr_page_new_rm (rmmservice, createdtask.dw, &exc); */
  if (exc._type != exc_l4_no_exception)
    return -9;
  return createdtask.id.task;
}
