#include <services/lib/sm_handle.h>

int set_owner_sm_handle (sm_handle_t h, LnThread t) 
{
  if (!ACTIVE_HANDLE(h)) return SM_HANDLE_SET_UNUSED;
  SM_HANDLE_PTR(h)->owner = t;
  return SM_OK;
}





int set_permissions_sm_handle(sm_handle_t h, unsigned perms) 
{
  if (!ACTIVE_HANDLE(h)) return SM_HANDLE_SET_UNUSED;
  SM_HANDLE_PTR(h)->perms = perms;
  return SM_OK;
}






int set_attached_obj_sm_handle(sm_handle_t h, void *obj) 
{
  if (!ACTIVE_HANDLE(h)) return SM_HANDLE_SET_UNUSED;
  SM_HANDLE_PTR(h)->obj = obj;
  return SM_OK;
}





sm_handle_t new_alias_sm_handle (sm_handle_t h, LnThread owner, unsigned perms) 
{
  if (!ACTIVE_HANDLE(h)) return 0;
  return new_sm_handle(owner, perms, SM_HANDLE_PTR(h)->obj);
}


sm_handle_t set_alias_sm_handle (sm_handle_t alias, sm_handle_t orig) 
{
  sm_handle_t old_alias;
  sm_handle *optr, *aptr;

  if (!ACTIVE_HANDLE(alias)) return 0;
  if (!ACTIVE_HANDLE(orig)) return 0;

  DPRINTF(("set_alias_sm_handle: alias: 0x%x, orig: 0x%x\n",
	   (unsigned) alias, (unsigned) orig));

  old_alias = alias;
  aptr = SM_HANDLE_PTR(alias);
  optr = SM_HANDLE_PTR(orig);

  DPRINTF(("set_alias_sm_handle: ptrs: alias: 0x%x, orig: 0x%x; next: 0x%x\n",
	 (unsigned) aptr, (unsigned) optr, (unsigned) optr->next.value));

  if (optr->next.s.index) {
    aptr->next.s.index = optr->next.s.index;
  }
  else {
    aptr->next.s.index = SM_HANDLE_TO_INDEX(orig);
  }
  optr->next.s.index = SM_HANDLE_TO_INDEX(alias);

  DPRINTF(("set_alias_sm_handle: assigns: alias->next: 0x%x, orig->next: 0x%x\n",
	 (unsigned) aptr->next.value, (unsigned) optr->next.value));

  return old_alias;
}





