
#include <stdio.h>   // for printf: should change to printk and ifdef LINUX
#ifdef LINUX
#include <stdlib.h>
#endif
#include <services/lib/sm_handle.h>
#include <l4/kdebug.h>
//#include <l4/ipc.h>
//#include "utils.h"


sm_handle_table *sm_ht = 0;
//lock_t smh_table_lock;



/*******************************************************
 *                                                     
 * Initialize: create initial handle table of specified size
 *
 *******************************************************/

int initialize_sm_handle_system (int max_handles) {
  int i;
  sm_handle *data;

  /* Create sm_handle_table */
  /* Should allocate more? (e.g., up to page boundary?) */

  if (sm_ht) return SM_HANDLE_SYS_INIT;
  sm_ht = (sm_handle_table *) sm_malloc (sizeof(sm_handle_table));
  sm_ht->data = data = (sm_handle *) sm_malloc (max_handles * sizeof(sm_handle));
  DPRINTF(("initialize: malloc'ed at 0x%x; size 0x%x\n",
	   data, max_handles * sizeof(sm_handle)));

  if (!data) return SM_HANDLE_SYS_ALLOC;
  sm_ht->size = max_handles;
  sm_ht->used = 0;
  sm_ht->low_free = data;
  sm_ht->high_free = data + (max_handles - 1);
  
  DPRINTF(("initialize: handle table starts at 0x%x; last entry 0x%x\n",
	   sm_ht->low_free, sm_ht->high_free));
  
  /* Initialize handle table entries */

  for (i = 0; i < max_handles; i++) {
    data[i].owner = SM_INVALID_OWNER;
    data[i].obj = data + (i+1);
    data[i].perms = 0;
    data[i].next.value = 0;
  }
  data[i-1].obj = (sm_handle *) 0;   

  return SM_OK;
} 



/*******************************************************
 *                                                     
 * Reinitialize: simple copying reinitialize
 *
 *******************************************************/

/* NOTE: Should lock on individual entries? */

int reinitialize_sm_handle_system (int max_handles) {
  int current_size = sm_ht->size;
  int i;
  sm_handle *data, *new;
  
  /* Create a new table */
  new = (sm_handle *) sm_malloc (max_handles * sizeof(sm_handle));
  if (!new) return SM_HANDLE_SYS_ALLOC;

  /* Copy the existing handles to the new data */
  DPRINTF(("reinitialize: old size: %d\n", sm_ht->size));
  DPRINTF(("reinitialize: data: 0x%x; new: 0x%x\n", sm_ht->data, new));

  data = sm_ht->data;
  for (i = 0; i < sm_ht->size; i++) {
    new[i].owner = data[i].owner;
    if (new[i].owner == SM_INVALID_OWNER) {
      new[i].obj = new + SM_PTR_TO_INDEX(sm_ht, (sm_handle *) data[i].obj);
    }
    else {
      new[i].obj = data[i].obj;
    }
    new[i].perms = data[i].perms;
    new[i].next = data[i].next;
    DPRINTF(("reinitialize: index: %d; data[%d].next: 0x%x; new: 0x%x; new[%d].next: 0x%x\n", 
	   (data[i].next.value ? SM_HANDLE_TO_INDEX(data[i].next.value) : 0), i, (unsigned) data[i].next.value, (unsigned) new, i, (unsigned) new[i].next.value));
  }

  DPRINTF(("reinitialize: copied: %d\n", i));

  /* Initialize new entries */
  for (; i < max_handles; i++) {
    new[i].owner = SM_INVALID_OWNER;
    new[i].obj = new + (i+1);
    new[i].perms = 0;
    new[i].next.value = 0;
  }

  DPRINTF(("reinitialize: initialized up to: %d\n", max_handles));

  /* Reset low_free: first new entry */
  /* NOTE: Must do before we reset sm_ht->data */
  DPRINTF(("reinitialize: old low_free index: %d; ptr: 0x%x\n", 
	   SM_PTR_TO_INDEX(sm_ht, sm_ht->low_free), sm_ht->low_free));
  if (sm_ht->low_free) {
    sm_ht->low_free = new + SM_PTR_TO_INDEX(sm_ht, sm_ht->low_free);
  }
  else {
    sm_ht->low_free = new + sm_ht->size;
  }
  sm_ht->high_free = new + (max_handles-1);
  new[max_handles-1].obj = (void *) 0;
  

  /* Update sm_handle_table data */
  #ifndef NO_DSM
  free(data);
  #endif
  sm_ht->data = new;
  sm_ht->size = max_handles;

  DPRINTF(("reinitialize: next free index: %d and ptr: 0x%x\n", 
	   SM_PTR_TO_INDEX(sm_ht, sm_ht->low_free), sm_ht->low_free));

  dump_all_sm_handles();

  return SM_OK;
}





/*******************************************************
 *                                                     
 * Used: number of handles used
 *
 *******************************************************/

int used_handles_sm_handle (void) {
  return sm_ht->used;
}



/*******************************************************
 *                                                     
 * max: the maximum index of a handle
 *
 *******************************************************/

int max_handles_sm_handle (void) {
  return sm_ht->size;
}




/*******************************************************
 *                                                     
 * min_max: next free handle index
 *
 *******************************************************/

sm_handle *min_max_handles_sm_handle (void) {
  return (sm_ht->low_free);
}



/*******************************************************
 *                                                     
 * new: new handle in next free location with incremented
 * version number.  Finds the next new free location and 
 * tracks the highest used location.
 *
 *******************************************************/

sm_handle_t new_sm_handle (LnThread owner, unsigned perms, void *obj) {
  sm_handle *smh = sm_ht->low_free;
  int i, version;

  DPRINTF(("new_sm_handle: ptr: 0x%x\n", (unsigned) smh));

  if (!smh) return (sm_handle_t) SM_HANDLE_INVALID;   /* full */

  /* set next free (low_free) */
  if (smh->obj)
    sm_ht->low_free = smh->obj;    /* this one was next in free list */    
  else
    sm_ht->low_free = (sm_handle *) 0;

  /* set handle data */
  smh->next.value = 0;
  smh->owner = owner;
  smh->perms = perms;
  DPRINTF(("new_sm_handle: old version: %d\n", smh->next.s.version));
  version = ((unsigned) smh->next.s.version + 1) % SM_HANDLE_VERSIONS;
  DPRINTF(("new_sm_handle: new version: %d\n", version));
  smh->next.s.version = version;
  smh->obj = obj;
  DPRINTF(("new_sm_handle: new version: %d\n", smh->next.s.version));
  sm_ht->used++;

  DPRINTF(("new_sm_handle: smh 0x%x; index %d\n", (unsigned) smh, 
	  SM_PTR_TO_INDEX(sm_ht, smh)));
  return (sm_handle_t) (SM_PTR_TO_INDEX(sm_ht, smh) | smh->next.value);
}



/*******************************************************
 *                                                     
 * free: clear data of handle specified.  Keep the version 
 * info for the next handle at this location.
 *
 *******************************************************/

sm_handle_t free_sm_handle (sm_handle_t h) {
  int i;
  sm_handle *hptr, *aptr;
  sm_handle_t next, aft;

  if (!SM_HANDLE_ACTIVE(h)) return SM_HANDLE_ILLEGAL_INDEX; 
  hptr = SM_HANDLE_PTR(h);

  DPRINTF(("free_sm_handle: handle: 0x%x;index: %d\n", (unsigned) hptr, SM_HANDLE_TO_INDEX(h)));

  /* Reset alias list if any: remove d below 
   *  o -> d -> n -> ... -> o  ==> o -> n -> ... -> o */

  if (next = hptr->next.s.index) {
    aptr = hptr;
    while (SM_HANDLE_TO_INDEX(aft = aptr->next.s.index) != SM_HANDLE_TO_INDEX(h)) {
      aptr = SM_HANDLE_PTR(aft);
      DPRINTF(("free_sm_handle: next ptr: 0x%x\n", (unsigned) aptr));
    } 
    aptr->next.s.index = next;
  }
  else 
    DPRINTF(("free_sm_handle: No next\n"));

  sm_ht->used--;


  DPRINTF(("free_sm_handle: after next update\n"));

  /* invalidate freed handle */
  hptr->owner = SM_INVALID_OWNER;
  hptr->next.s.index = 0;
  hptr->perms = 0;

  DPRINTF(("free_sm_handle: after hptr update\n"));

  /* add to end of free list */
  if (sm_ht->low_free) {
    sm_ht->high_free->obj = hptr;   /* set next of former last */
  }
  else {
    sm_ht->low_free = hptr;       /* new first in list */
  }
  sm_ht->high_free = hptr;       /* set new last */
  hptr->obj = (void *) 0;        /* set next of new last */

  DPRINTF(("free_sm_handle: after high free update: new high_free: 0x%x\n", 
	   sm_ht->high_free));
  DPRINTF(("free_sm_handle: done\n"));

  return SM_OK;  
}


