

#include <stdio.h>  // for printf: should change to printk and ifdef LINUX
#ifdef LINUX
#include <sys/types.h>
#else
typedef unsigned long int ulong;
#endif
#include "sm_handle.h"

/* Malloc from static memory -- no free */

#ifdef NO_DSM
typedef struct {
  ulong cur;
  ulong end;
} sm_heap;

sm_heap heap;

int heap_init = 0;


ulong smh_heap_init(ulong ptr, int size)
{
  DPRINTF(("smh_heap_init: ptr: 0x%x, size: %d\n", ptr, size));
  heap_init = 1;
  heap.cur = ptr;
  heap.end = heap.cur + size;
  DPRINTF(("smh_heap_init: end: 0x%x\n", heap.end));
}


ulong smh_malloc(int size)
{
  if (!heap_init) {
    DPRINTF(("smh_malloc: heap not initialized...\n"));
    return 0;
  }

  if (heap.cur+size > heap.end) {
    DPRINTF(("smh_malloc: vaddr: %x; size: %x; heap_end:%x\n", (unsigned) heap.cur, (unsigned) size, (unsigned) heap.end));
    return 0;
  }
  heap.cur += size;
  return heap.cur;
}
#endif
