
#include <stdio.h>
#include <stdlib.h>
#include "sm_handle.h"


#ifdef NO_DSM
#define HEAP_SIZE 131072  /* 128K */
ulong heap_ptr[131072];
#else
char *sm_malloc(int s) {
  return malloc(s);
}
#endif

dword_t main_stack[1024];

sm_handle_t safe_create_sm_handle(LnThread owner, unsigned perms, void
				 *attached_obj, int table_incr) {
  sm_handle_t h;

  h = new_sm_handle(owner, perms, attached_obj);
  printf("handle: next free spot: %d\n", min_max_handles_sm_handle());

  if (h == SM_HANDLE_INVALID) {
    printf("Table full\n");
    printf("Handle used = %d\n", used_handles_sm_handle());
    printf("Handle table size = %d\n", max_handles_sm_handle());
      
    if (table_incr > 0) {
      if (reinitialize_sm_handle_system(max_handles_sm_handle() 
				       + table_incr)) {
	printf("Error: reinitialization problem\n");
	return h;
      }
      printf("ReInitialized: max handles = %d\n", max_handles_sm_handle());
      h = new_sm_handle(owner, perms, attached_obj);
    }
  }
  return h;
}




int main (void)
{
  int count = 0, i;
  sm_handle_t h = 0, fh, orig, next;
  sm_handle smh, *hptr, *nptr;
  char test[] = "hello world!";
  char test2[] = "aliased";
  

  /* Initialization */
  /* NOTE: Multiple instances of a handle server? */

  printf("Initialized: start\n");

#ifdef NO_DSM
  printf("Initialized: creating local heap...\n");
  smh_heap_init((ulong) &heap_ptr, HEAP_SIZE);
#else
  sm_malloc(1);
#endif

  if ((initialize_sm_handle_system(100)) != SM_OK) {
    printf("Error: initialization problem\n");
    exit(-1);
  }

  printf("Initialized: max handles = %d\n", max_handles_sm_handle());


  /* Server loop simulation */

  while (1) {
    count++;

    h = safe_create_sm_handle(10, 20, (void *) test, 100);
    if (read_sm_handle(h, smh, hptr) == SM_OK)
      printf("handle %d: owner: %x; perms: %x; obj: %x\n", count,
	     owner_sm_handle(hptr), permissions_sm_handle(hptr), 
	     (unsigned) attached_obj_sm_handle(hptr));

    if (count > 1000) break;

  }

  orig = h;
  hptr = SM_HANDLE_PTR(h);

  /* Free and create some more handles */

  count = 17;
  for (i = 1; i < 100; i++) {
    if (!count) count= 17;
    count = (count * 13) % 1000;
    
    printf("handle: version: %d; handle version: 0x%x\n", 
	   SM_HANDLE_PTR(h)->next.s.version, ((unsigned) h & SM_HANDLE_VERSION_MASK));    

    if (read_sm_handle(h, smh, hptr) == SM_OK) {
      l4_threadid_t th;
      th.dw = 10;
      if (AUTHORIZE_SM_HANDLE_BITOP(hptr, th, 20)) {
	printf("handle: authorized...\n");
	printf("handle: msg: %s\n", (char *) smh.obj);
	if (strcmp("aliased", (char *) smh.obj) == 0) {
	  printf("handle: next index: %d\n", (char *) smh.next.s.index);
	  next = smh.next.s.index;
	  while (next != SM_HANDLE_TO_INDEX(h)) {
	    nptr = SM_HANDLE_PTR(next);
	    printf("next handle %d: owner: 0x%x; perms: 0x%x; obj: 0x%x; next: 0x%x\n", 
		   (unsigned) next, owner_sm_handle(nptr), permissions_sm_handle(nptr), 
		   (unsigned) attached_obj_sm_handle(nptr),
		   (unsigned) next_alias_sm_handle(nptr));
	    next = nptr->next.s.index;
	  }
	}
      }
      else {
	printf("handle: *not* authorized\n");
	printf("handle %d: owner: 0x%x; perms: 0x%x; obj: 0x%x; next: 0x%x\n", 
	       (unsigned) (h & SM_HANDLE_MASK), owner_sm_handle(hptr), permissions_sm_handle(hptr), 
	       (unsigned) attached_obj_sm_handle(hptr),
	       (unsigned) next_alias_sm_handle(hptr));
      }
      fh = count | (SM_HANDLE_PTR(count)->next.s.version << SM_HANDLE_VOFFSET);
      if (fh != orig) 
	free_sm_handle(fh);
      else 
	printf("handle: not freeing handle (fh == orig)\n");
    }
    else {
      printf("handle: handle not read\n");
    }


    printf("handle: next free spot: 0x%x\n", min_max_handles_sm_handle());

    if (count > 900) {
      h = new_alias_sm_handle(orig, 10, 20);
      hptr = SM_HANDLE_PTR(h);
      set_attached_obj_sm_handle(h, test2);
      set_alias_sm_handle(h, orig);
      if (read_sm_handle(h, smh, hptr) == SM_OK) {
	printf("handle: orig: 0x%x\n", (unsigned) orig);
	printf("handle 0x%x: owner: 0x%x; perms: 0x%x; obj: 0x%x; next: 0x%x\n", 
	       (unsigned) h, owner_sm_handle(hptr), permissions_sm_handle(hptr), 
	       (unsigned) attached_obj_sm_handle(hptr),
	       (unsigned) next_alias_sm_handle(hptr));
      }
    }
  }
  exit(0);
}
