#include <stdarg.h>
#include <l4/kdebug.h>

static char buf[1024];

static inline 
void out_char(unsigned char c)
{
  asm(
      "int      $3      \n\t"
      "cmpb     $0,%%al \n\t"
      : /* No output */
      : "a" (c)
      );
}

int printf(const char * fmt, ...)
{
	va_list args;
	char *tmp = buf;

	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	while(*tmp) {
		out_char(*tmp);
		if (*tmp == '\n')
			out_char('\r');
		tmp++;
	}
	return 0;
}


void panic(const char * fmt, ...) 
{
	va_list args;
	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	printf(buf);
	enter_kdebug("Panic");
	while(1);
}
