#include <linux/linkage.h>

#ifdef __L4_VERSION_X__
    .global serializer
#else /* __L4_VERSION_X__ */
    .global serializer_low
    .global serializer_high
#endif /* __L4_VERSION_X__ */

ENTRY(wait_for_resume)
    pushl %eax                  / Make room for return address
    pushf                       / Push everything
    pushal
    movl $0xffffffff, %eax	/ No send operation
    movl $0x0, %ecx             / L4_IPC_NEVER 
    movl $0x0, %ebp             / Reg receive operation
#ifdef __L4_VERSION_X__
    movl (serializer), %esi
#else /* __L4_VERSION_X__ */
    movl (serializer_low), %esi
    movl (serializer_high), %edi
#endif /* __L4_VERSION_X__ */
    int $0x30                   / Receive return address
    movl %edx, 0x24(%esp)       / Put return address on stack
    popal                       / Pop everything
    popf
    ret                         / "Jump" to return address
