/* Miscellaneous useful stuff */

#include <stdio.h>
#include <stdarg.h>
#include <services/lib/utils.h>

lock_t hprintf_lock = 0;

static char herc_buf[2048];

/* a thread-safe printf to the kdebug console */
int hprintf(const char *fmt, ...)
{
  va_list args;
  int i;
  char *p, *buf_end;

  va_start(args, fmt);
  enter_lock(&hprintf_lock);
  i = hvsprintf(herc_buf, fmt, args); /* hopefully i < sizeof(herc_buf)-4 */
  
  if (!(i < sizeof(herc_buf)))
    enter_kdebug("hprintf buffer overflow");
  
  buf_end = herc_buf + i;
  va_end(args);
  for (p = herc_buf; p < buf_end; p++) {
    if (*p == '\n')
      {
	outchar('\r');
	outchar('\n');
      }
    else
      outchar(*p);
  }
  leave_lock(&hprintf_lock);
  return i;
}
