/* $Id: debug.h,v 1.1.1.1 1999/04/06 19:21:00 yoonho Exp $ */
#ifndef __DEBUG_H
#define __DEBUG_H

#include <linux/linkage.h>

char * get_signal_name(unsigned);
char * get_syscall_name(unsigned int);

int stack_fill(char * stack_top, char * stack_bottom);
int stack_used(char * stack_top, char * stack_bottom);
extern asmlinkage int herc_printf(const char *fmt, ...)
     __attribute__ ((format (printf, 1, 2)));

#ifdef DEBUG_PRINT
#define DPRINT(format,args...) herc_printf(format,##args)
#else
#define DPRINT(format,args...)
#endif

#ifdef DEBUG_PRINT
#define ELSE_DPRINT(format,args...) else herc_printf(format,##args)
#else
#define ELSE_DPRINT(format,args...)
#endif

#ifdef DEBUG_PRINT
#define COND_DPRINT(cond,format,args...) if ((cond)) herc_printf(format,##args)
#else
#define COND_DPRINT(cond,format,args...)
#endif

#ifdef WATCH_INTR_COUNT
static inline void l4_check_intr_count(char *who);
static inline void l4_check_intr_count(char *who)
{
  while (intr_count)
    {
      extern unsigned long int irqs_in_progress;
      int i=0;
      printk("%s: intr_count != 0; activ: %lx yielding...\n", 
	     who, irqs_in_progress);
      l4_thread_switch(L4_NIL_ID);
      if (i>10)
	{
	  /* try to switch directly to all interrupt threads */
	  int j,interrupt;
	  l4_threadid_t to=get_l4_id_from_stack();
	  for(interrupt=0; interrupt<17; interrupt++)
	    {
	      if (intr_count & (1 << interrupt))
		printk("%s: switching to %x(activ)\n", who, interrupt);
	      else
		printk("%s: switching to %x(inactiv)\n", who, interrupt);
	      to.id.lthread=interrupt + 16;
	      for(j=0; j<10; j++)
		l4_thread_switch(to);
	    }
	  if (intr_count)
	    {
	      printk("%s: intr_count still != 0; activ: %lx trying again\n", 
		     who, irqs_in_progress);
	      enter_kdebug("intr_count");
	    }
	}
    }
}
#endif

#endif /* debug.h */
