/* $Id: perform.h,v 1.1.1.1 1999/04/06 19:21:01 yoonho Exp $ */

#ifndef __L4_I386_PERFORM_H
#define __L4_I386_PERFORM_H

#ifndef __ASSEMBLY__

static inline void
reset_event_counter(void)
{
   asm volatile("xor %%eax, %%eax\n"
		"xor %%edx, %%edx\n"
		"movl $0x12, %%ecx\n"
		".byte 0x0f, 0x30\n"
		"movl $0x13, %%ecx\n"
		".byte 0x0f, 0x30\n"
		: : : "cx", "ax", "dx" 
		);
};

static inline void
read_event_counter_long(long long *counter0, long long *counter1)
{
  asm volatile(
	       /*	       "movl	$0, %%eax\n"
	       "movl	$0x11, %%ecx\n"
	       ".byte 0x0f, 0x30\n" *//* stop event counting */
	       "movl $0x12, %%ecx\n"
	       ".byte 0x0f, 0x32\n"
	       "movl %%eax, (%%ebx)\n"
	       "movl %%edx, 4(%%ebx)\n"
	       "movl $0x13, %%ecx\n"
	       ".byte 0x0f, 0x32\n"
	       "movl %%eax, (%%esi)\n"
	       "movl %%edx, 4(%%esi)\n"
	       : /* no output */
	       : "b" (counter0), "S" (counter1)
	       : "ax", "cx", "dx"
	       );
}

static inline void
read_event_counter(int *counter0, int *counter1)
{
  asm volatile("pushl	%%edx\n"
	       ".byte 0x0f, 0x30\n"
	       "movl $0x12, %%ecx\n"
	       ".byte 0x0f, 0x32\n"
	       "movl %%eax, %%ebx\n"
	       "movl $0x13, %%ecx\n"
	       ".byte 0x0f, 0x32\n"
	       "popl	%%edx\n"
	       : "=b" (*counter0), "=a" (*counter1)
	       : "1" (0), "c" (0x11)
	       );
}

static inline void 
select_event(int event0, int event1)
{
   asm volatile(".byte 0x0f, 0x30\n"
		:
		:
 		"a" (event0 + (event1 << 16)),
		"d" (0),
		"c" (0x11)
		);
};

extern inline void  
read_time(unsigned long *time)
{
  __asm__ volatile ("pushl	%%edx\n"
		    ".byte 0x0f, 0x31\n"
		    "popl	%%edx\n"
		    : "=a" (*time)
		    :
		    : "dx"
		    );
};

#endif /* !__ASSEMBLY__ */

#define ASM_RDTSC .byte 0x0f, 0x31

#define PEC_RD_MISS          0x003	/* 000011B */
#define PEC_WR_MISS          0x008	/* 000100B */
#define PEC_RW_MISS          0x029	/* 101001B */
#define PEC_EX_MISS          0x00e	/* 001110B */

#define PEC_D_WBACK          0x006	/* 000110B */

#define PEC_RW_TLB           0x002	/* 00010B */
#define PEC_EX_TLB           0x00d	/* 01101B */

#define PEC_A_STALL          0x01f	/* 11111B */
#define PEC_W_STALL          0x019	/* 11001B */
#define PEC_R_STALL          0x01a	/* 11010B */
#define PEC_X_STALL          0x01b	/* 11011B */

#define PEC_AGI_STALL        0x01f	/* 11111B */

#define PEC_PIPLINE_FLUSH    0x015	/* 10101B */

#define PEC_NON_CACHE_RD     0x01e	/* 11110B */
#define PEC_NCACHE_REFS      0x01e	/* 11110B */
#define PEC_LOCKED_BUS       0x01c	/* 11100B */

#define PEC_MEM2PIPE         0x009	/* 01001B */
#define PEC_BANK_CONF        0x00a	/* 01010B */


#define PEC_INSTRS_EX        0x016	/* 10110B */
#define PEC_INSTRS_EX_V      0x017	/* 10111B */


#define PEC_CNT_NOTHING      (0x00 << 6)	/* 00B << 6 */
#define PEC_CNT_EVENT_PL0    (0x01 << 6)	/* 01B << 6 */
#define PEC_CNT_EVENT_PL3    (0x02 << 6)	/* 10B << 6 */
#define PEC_CNT_EVENT        (0x03 << 6)	/* 11B << 6 */
#define PEC_CNT_CLOCKS_PL0   (0x05 << 6)	/* 101B << 6 */
#define PEC_CNT_CLOCKS_PL3   (0x06 << 6)	/* 110B << 6 */
#define PEC_CNT_CLOCKS       (0x07 << 6)	/* 111B << 6 */

#endif  /* __L4_I386_PERFORM_H */
