/*
 *  linux/arch/i386/head.S
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 *  head.S contains the 32-bit startup code.
 */
/*
 * XXX Now it only contains the definitions of swapper_page_dir, pg0, 
 * empty_zero_page, bad_page, bad_page_table
 */  

.text
#include <linux/tasks.h>
#include <linux/linkage.h>
#include <asm/segment.h>
#include <linux/config.h>

#include "../include/mb_info.h"

#define CL_MAGIC_ADDR	0x90020
#define CL_MAGIC	0xA33F
#define CL_BASE_ADDR	0x90000
#define CL_OFFSET	0x90022

/* _start's offset into a page.  we need this value to compute page-aligned
   symbols later in this file */
#ifdef __ELF__
# define START_ALIGN 0
#else
# define START_ALIGN 0x20
#endif
#define MB4 (4*1024*1024)
#define MB8 (8*1024*1024)    
ENTRY(stext)
ENTRY(_stext)
ENTRY(start)
ENTRY(_start)
ENTRY(__crt_dummy__)

ENTRY(startup_32)

/* check for a multiboot-compliant boot */
	leal    SYMBOL_NAME(swapper_pg_dir), %esp
	cmpl	$MULTIBOOT_VALID, %eax
	jnz	1f
	movl	%ebx, SYMBOL_NAME(multiboot_info)
1:	
	
#ifdef CONFIG_M4_PAGES
#if 0
    int	$3
    jmp	1f
    .ascii	"startup_32"
1:  
#endif
    movl    $-1,    %esi    #pager = nil id
    xorl    %eax,   %eax    #get information about thread 0        
    movl    %esi,   %edi    #pager = nil id
    movl    %esi,   %ebx    #preempter=nil id    
    movl    %esi,   %ebp    #preempter=nil id
    movl    %esi,   %ecx    #esp = invalid
    movl    %esi,   %edx    #eip = invalid

    int	    $0x35

    movl    $(SYMBOL_NAME(swapper_pg_dir) + 1), %edx
    /* address of swapper_pg_dir + log dualis 4 MB * 4 + rmap option */
    movl    $(SYMBOL_NAME(swapper_pg_dir) + (22 * 4) + 2), %ebp
    call    __request_4M_page

    
#if 0
    movl    $(SYMBOL_NAME(swapper_pg_dir) + MB4 + 1), %edx
    /* address of swapper_pg_dir + log dualis 4 MB * 4 + rmap option */
    movl    $(SYMBOL_NAME(swapper_pg_dir) + MB4 + (22 * 4) + 2), %ebp
    call    __request_4M_page
    movl    $(SYMBOL_NAME(swapper_pg_dir) + MB8 + 1), %edx
    /* address of swapper_pg_dir + log dualis 4 MB * 4 + rmap option */
    movl    $(SYMBOL_NAME(swapper_pg_dir) + MB8 + (22 * 4) + 2), %ebp
    call    __request_4M_page

#endif

    
    jmp	SYMBOL_NAME(linux_startup)
            
__request_4M_page:      
    movl    $(22*4), %ebx
    xorl    %ecx, %ecx
    xorl    %eax, %eax
#if 0    
    int	$3
    jmp	1f
    .ascii	"calling sigma 0"
1:
#endif    
    int	    $0x30

    movl    %eax, %ecx
    
    andb    $0xf0, %cl
    orb	    %cl, %cl
    jnz	    __ipc_failed

    testb   $2, %al
    jz	    __no_mapping_received
    
    shrl    $2, %ebx	/* remove attributes */
    andl    $0x3f, %ebx	/* extract size */
#if 0
    int	$3
    jmp	1f
    .ascii "4mb requested"
1:
#endif      
    cmpl    $22, %ebx 
    jnz	    __wrong_size
    movl    $1, SYMBOL_NAME(kernel_mem_requested)
    jmp	    __cont

__no_mapping_received:	
    int	$3
    jmp	2f
    .ascii "no mapping received"
2:  
    jmp	    err
        
__ipc_failed:	
    int	$3
    jmp	2f
    .ascii "ipc failed"
2:  
    jmp	    err
__wrong_size:	
    int	$3
    nop
    jmp	3f
    .ascii "wrong size"
3:  
    jmp	    err
                    
err:
    movl $1, SYMBOL_NAME(mb4_pages_dont_work)

__cont:
    ret
#endif    
    jmp	SYMBOL_NAME(linux_startup)

ENTRY(kernel_mem_requested)	.long	 0  /* XXX this is never used */
ENTRY(multiboot_info)		.long	 0    

/*
 * multiboot header
 */	
 	/* MultiBoot header - see multiboot.h.  */
#ifdef __ELF__
 	.align	4
#else /* ! __ELF__, that mean a.out assembler */
	.align	2
#endif

boot_hdr:
 	.long	0x1BADB002		/* magic */
 	.long	0x00010000		/* flags: AOUT_KLUDGE */
	.long   - 0x00010000 - 0x1BADB002
 	.long	boot_hdr		/* header_addr */
 	.long	SYMBOL_NAME(start)	/* load_addr */
 	.long	SYMBOL_NAME(edata)	/* load_end_addr */
 	.long	SYMBOL_NAME(end)	/* bss_end_addr */
 	.long	SYMBOL_NAME(startup_32)	/* entry */

ENTRY(null_pointer_check)
	.long	0
ENTRY(sigma0_id)
	.long -1
	.long -1
ENTRY(sigma0_initialized)
	.long 0    
/*
 * Defined elsewhere (YHP)
 *
ENTRY(jiffies)
	.long 0    
 */
ENTRY(kernel_idt)
        .rept 0x20
                .long 0
        .endr
	
/*
 * swapper_pg_dir is the main page directory, address 0x00001000 (or at
 * address 0x00101000 for a compressed boot).
 */
	
/*
 * page 0 is made non-existent, so that kernel NULL pointer references get
 * caught. Thus the swapper page directory has been moved to 0x1000
 *
 * XXX Actually, the swapper page directory is at 0x1000 plus 1 megabyte,
 * with the introduction of the compressed boot code.  Theoretically,
 * the original design of overlaying the startup code with the swapper
 * page directory is still possible --- it would reduce the size of the kernel
 * by 2-3k.  This would be a good thing to do at some point.....
 */
.org 0x1000 - START_ALIGN 
ENTRY(swapper_pg_dir)
/*
 * The page tables are initialized to only 4MB here - the final page
 * tables are set up later depending on memory size.
 */
.org 0x2000  - START_ALIGN 
ENTRY(pg0)

.org 0x3000 - START_ALIGN 
ENTRY(empty_bad_page)

.org 0x4000 - START_ALIGN 
ENTRY(empty_bad_page_table)

.org 0x5000 - START_ALIGN 
ENTRY(empty_zero_page)

.org 0x6000 - START_ALIGN 
ENTRY(emu_lib_text)

.org 0x7000 - START_ALIGN 
ENTRY(init_user_stack)

.org 0x8000 - START_ALIGN 
ENTRY(interrupt_stacks)

.org 0x1a000 - START_ALIGN
ENTRY(task_to_proc)		/* needs 2048 x 4 bytes */

.org 0x1c000


#if 1
.globl SYMBOL_NAME(current_set) 
.globl SYMBOL_NAME(current_pdir)
.globl SYMBOL_NAME(need_resched)
.globl SYMBOL_NAME(syscall_count)
.globl SYMBOL_NAME(last_client)            
ALIGN
SYMBOL_NAME_LABEL(current_set) .long 0
SYMBOL_NAME_LABEL(current_pdir) .long 0
SYMBOL_NAME_LABEL(need_resched) .long 0
SYMBOL_NAME_LABEL(syscall_count) .long 0
SYMBOL_NAME_LABEL(last_client) .long 0        
                
SYMBOL_NAME_LABEL(current_ptregs) .long 0            
#endif
/* This is the default interrupt "handler" :-) */
int_msg:
	.asciz "Unknown interrupt\n"
	ALIGN
ENTRY(ignore_int)
	cld
	pushl %eax
	pushl %ecx
	pushl %edx

	pushl $int_msg
	call SYMBOL_NAME(printk)
	popl %eax

	popl %edx
	popl %ecx
	popl %eax
	iret
