/*
 * $Id: idt.c,v 1.1.1.1 1999/04/06 19:21:03 yoonho Exp $
 */ 
#include <l4/kdebug.h>
#include <l4/idt.h>

void InitIDT(IntHandlerT*, int);

IDTEntryT gdb_idt[20];   /* space for new IDT */

struct 
{
    unsigned short int size __attribute__((packed));
    unsigned long address __attribute__((packed));
} gdb_idt_descr = {20 * 8 -1, (unsigned long)gdb_idt};


/*
 * Installs the IDT pointed to by IntHandler, containing num entries
 */

void 
InitIDT(IntHandlerT *IntHandler, int num)
{
    int i;

    IDTEntryT dummy = { 0, 0, 0, TRAPGATE, USERLEVEL, SEGPRESENT, 0 }; 

    for (i=0; i<num; i++)
    {
        dummy.IntHandlerLow  =  (long)IntHandler[i];
	dummy.IntHandlerHigh = ((long)IntHandler[i]) >> 16;
	gdb_idt[i] = dummy;
    }
    asm("lidt	(%%eax)\n\t" : : "a" (&gdb_idt_descr)); 
}















